/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powerinductorsix;

import java.util.List;
import mods.eln.Eln;
import mods.eln.item.FerromagneticCoreDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.misc.series.ISerie;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.powerinductorsix.PowerInductorSixElement;
import mods.eln.sixnode.powerinductorsix.PowerInductorSixRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class PowerInductorSixDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    Obj3D.Obj3DPart InductorBaseExtention;
    Obj3D.Obj3DPart InductorCables;
    Obj3D.Obj3DPart InductorCore;
    Obj3D.Obj3DPart Base;
    ISerie serie;

    public PowerInductorSixDescriptor(String name, Obj3D obj, ISerie serie) {
        super(name, PowerInductorSixElement.class, PowerInductorSixRender.class);
        this.serie = serie;
        this.obj = obj;
        if (obj != null) {
            this.InductorBaseExtention = obj.getPart("InductorBaseExtention");
            this.InductorCables = obj.getPart("InductorCables");
            this.InductorCore = obj.getPart("InductorCore");
            this.Base = obj.getPart("Base");
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    public double getlValue(int cableCount) {
        if (cableCount == 0) {
            return 0.0;
        }
        return this.serie.getValue(cableCount - 1);
    }

    public double getlValue(IInventory inventory) {
        ItemStack core = inventory.func_70301_a(0);
        if (core == null) {
            return this.getlValue(0);
        }
        return this.getlValue(core.field_77994_a);
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    public double getRsValue(IInventory inventory) {
        ItemStack core = inventory.func_70301_a(1);
        if (core == null) {
            return 1.0E9;
        }
        FerromagneticCoreDescriptor coreDescriptor = (FerromagneticCoreDescriptor)FerromagneticCoreDescriptor.getDescriptor(core);
        double coreFactor = coreDescriptor.cableMultiplicator;
        return Eln.instance.lowVoltageCableDescriptor.electricalRs * coreFactor;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    void draw() {
        if (null != this.Base) {
            this.Base.draw();
        }
        if (null != this.InductorBaseExtention) {
            this.InductorBaseExtention.draw();
        }
        if (null != this.InductorCables) {
            this.InductorCables.draw();
        }
        if (null != this.InductorCore) {
            this.InductorCore.draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.2f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.draw();
        } else {
            super.renderItem(type, item, data);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return super.getFrontFromPlace(side, player).left();
    }
}

