/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powerinductorsix;

import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Inductor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.powerinductorsix.PowerInductorSixContainer;
import mods.eln.sixnode.powerinductorsix.PowerInductorSixDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class PowerInductorSixElement
extends SixNodeElement {
    PowerInductorSixDescriptor descriptor;
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    Inductor inductor = new Inductor("inductor", this.positiveLoad, this.negativeLoad);
    boolean fromNbt = false;
    SixNodeElementInventory inventory = new SixNodeElementInventory(2, 64, this);

    public PowerInductorSixElement(SixNode SixNode2, Direction side, SixNodeDescriptor descriptor) {
        super(SixNode2, side, descriptor);
        this.descriptor = (PowerInductorSixDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.inductor);
        this.positiveLoad.setAsMustBeFarFromInterSystem();
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (lrdu == this.front.right()) {
            return this.positiveLoad;
        }
        if (lrdu == this.front.left()) {
            return this.negativeLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (lrdu == this.front.right()) {
            return 1;
        }
        if (lrdu == this.front.left()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U", Math.abs(this.inductor.getU())) + Utils.plotAmpere("I", this.inductor.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        this.setupPhysical();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.setupPhysical();
    }

    public void setupPhysical() {
        double rs = this.descriptor.getRsValue(this.inventory);
        this.inductor.setL(this.descriptor.getlValue(this.inventory));
        this.positiveLoad.setRs(rs);
        this.negativeLoad.setRs(rs);
        if (this.fromNbt) {
            this.fromNbt = false;
        } else {
            this.inductor.resetStates();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.fromNbt = true;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new PowerInductorSixContainer(player, this.inventory);
    }
}

