/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powersocket;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.powersocket.PowerSocketElement;
import mods.eln.sixnode.powersocket.PowerSocketRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class PowerSocketDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    private Obj3D.Obj3DPart base;
    private Obj3D.Obj3DPart socket;
    private int subID;
    public int range;

    public PowerSocketDescriptor(int subID, String name, Obj3D obj, int range) {
        super(name, PowerSocketElement.class, PowerSocketRender.class);
        this.subID = subID;
        this.range = range;
        this.obj = obj;
        if (obj != null) {
            this.base = obj.getPart("SocketBase");
            switch (subID) {
                case 1: {
                    this.socket = obj.getPart("Socket50V");
                    this.voltageLevelColor = VoltageLevelColor.LowVoltage;
                    break;
                }
                case 2: {
                    this.socket = obj.getPart("Socket200V");
                    this.voltageLevelColor = VoltageLevelColor.MediumVoltage;
                    break;
                }
                default: {
                    this.socket = null;
                }
            }
        }
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addLight(this.newItemStack(1));
    }

    public void draw() {
        if (this.base != null) {
            this.base.draw();
        }
        if (this.socket != null) {
            this.socket.draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw();
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Supplies any device\nplugged in with energy.", new Object[0]).split("\n"));
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return LRDU.Down;
    }
}

