/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powersocket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.powersocket.PowerSocketContainer;
import mods.eln.sixnode.powersocket.PowerSocketDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PowerSocketElement
extends SixNodeElement {
    public static final HashMap<String, ArrayList<PowerSocketElement>> channelMap = new HashMap();
    public PowerSocketDescriptor descriptor;
    public NbtElectricalLoad powerLoad = new NbtElectricalLoad("powerLoad");
    public Resistor loadResistor = new Resistor(this.powerLoad, null);
    public IProcess PowerSocketSlowProcess = new PowerSocketSlowProcess();
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    public String channel = "Default channel";
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();
    public static final byte setChannelId = 1;
    double RpStack = 0.0;

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new PowerSocketContainer(player, this.inventory);
    }

    public PowerSocketElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.powerLoad);
        this.electricalComponentList.add(this.loadResistor);
        this.slowProcessList.add(this.PowerSocketSlowProcess);
        this.loadResistor.highImpedance();
        this.descriptor = (PowerSocketDescriptor)descriptor;
        this.slowProcessList.add(this.voltageWatchdog);
        this.voltageWatchdog.set(this.powerLoad).set(new WorldExplosion(this).cableExplosion());
        PowerSocketElement.channelRegister(this);
    }

    static void channelRegister(PowerSocketElement tx) {
        String channel = tx.channel;
        ArrayList<PowerSocketElement> list = channelMap.get(channel);
        if (list == null) {
            list = new ArrayList();
            channelMap.put(channel, list);
        }
        list.add(tx);
    }

    static void channelRemove(PowerSocketElement tx) {
        String channel = tx.channel;
        List list = channelMap.get(channel);
        if (list == null) {
            return;
        }
        list.remove(tx);
        if (list.isEmpty()) {
            channelMap.remove(channel);
        }
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return null;
        }
        if (this.front == lrdu) {
            return this.powerLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return null;
        }
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (this.front == lrdu) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.powerLoad.getU(), this.powerLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        this.setupFromInventory();
    }

    @Override
    protected void inventoryChanged() {
        super.inventoryChanged();
        this.sixNode.disconnect();
        this.setupFromInventory();
        this.sixNode.connect();
        this.needPublish();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        super.destroy(entityPlayer);
        this.unregister();
    }

    @Override
    public void unload() {
        super.unload();
        PowerSocketElement.channelRemove(this);
    }

    void unregister() {
        PowerSocketElement.channelRemove(this);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("channel", this.channel);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        PowerSocketElement.channelRemove(this);
        super.readFromNBT(nbt);
        this.channel = nbt.func_74779_i("channel");
        PowerSocketElement.channelRegister(this);
    }

    void setupFromInventory() {
        ItemStack cableStack = this.inventory.func_70301_a(0);
        if (cableStack != null) {
            ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack);
            desc.applyTo(this.powerLoad);
            this.voltageWatchdog.setUNominal(desc.electricalNominalVoltage);
        } else {
            this.voltageWatchdog.setUNominal(10000.0);
            this.powerLoad.highImpedance();
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    PowerSocketElement.channelRemove(this);
                    this.channel = stream.readUTF();
                    this.needPublish();
                    PowerSocketElement.channelRegister(this);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.channel);
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addToRp(double r) {
        this.RpStack += 1.0 / r;
    }

    public int getRange() {
        return this.getRange(this.descriptor, this.inventory);
    }

    private int getRange(PowerSocketDescriptor desc, SixNodeElementInventory inventory2) {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack == null) {
            return desc.range;
        }
        return desc.range + stack.field_77994_a;
    }

    class PowerSocketSlowProcess
    implements IProcess {
        PowerSocketSlowProcess() {
        }

        @Override
        public void process(double time) {
            PowerSocketElement.this.loadResistor.setR(1.0 / PowerSocketElement.this.RpStack);
            PowerSocketElement.this.RpStack = 0.0;
        }
    }
}

