/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powersocket;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.powersocket.PowerSocketDescriptor;
import mods.eln.sixnode.powersocket.PowerSocketGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PowerSocketRender
extends SixNodeElementRender {
    PowerSocketDescriptor descriptor;
    Coordonate coord;
    String channel;
    CableRenderDescriptor cableRender;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);

    public PowerSocketRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (PowerSocketDescriptor)descriptor;
        this.coord = new Coordonate(tileEntity);
    }

    @Override
    public void draw() {
        super.draw();
        this.descriptor.draw();
    }

    @Override
    public void refresh(float deltaT) {
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return this.cableRender;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new PowerSocketGui(this, player, this.inventory);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.channel = stream.readUTF();
            ItemStack cableStack = Utils.unserialiseItemStack(stream);
            if (cableStack != null) {
                ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack);
                this.cableRender = desc.render;
            } else {
                this.cableRender = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

