/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.resistor;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ResistorProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ResistorHeatThermalLoad;
import mods.eln.sixnode.resistor.ResistorContainer;
import mods.eln.sixnode.resistor.ResistorDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

public class ResistorElement
extends SixNodeElement {
    ResistorDescriptor descriptor;
    NbtElectricalLoad aLoad = new NbtElectricalLoad("aLoad");
    NbtElectricalLoad bLoad = new NbtElectricalLoad("bLoad");
    Resistor r = new Resistor(this.aLoad, this.bLoad);
    public NbtElectricalGateInput control;
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    ResistorHeatThermalLoad heater = new ResistorHeatThermalLoad(this.r, this.thermalLoad);
    ResistorProcess resistorProcess;
    public double nominalRs = 1.0;
    SixNodeElementInventory inventory = new SixNodeElementInventory(2, 64, this);

    public ResistorElement(SixNode SixNode2, Direction side, SixNodeDescriptor descriptor) {
        super(SixNode2, side, descriptor);
        this.descriptor = (ResistorDescriptor)descriptor;
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.aLoad.setRs(1.0E-9);
        this.bLoad.setRs(1.0E-9);
        this.electricalComponentList.add(this.r);
        if (this.descriptor.isRheostat) {
            this.control = new NbtElectricalGateInput("control");
            this.electricalLoadList.add(this.control);
        }
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalSlowProcessList.add(this.heater);
        this.thermalLoad.setAsSlow();
        double thermalC = this.descriptor.thermalMaximalPowerDissipated * this.descriptor.thermalNominalHeatTime / this.descriptor.thermalWarmLimit;
        double thermalRp = this.descriptor.thermalWarmLimit / this.descriptor.thermalMaximalPowerDissipated;
        double thermalRs = this.descriptor.thermalConductivityTao / thermalC / 2.0;
        this.thermalLoad.set(thermalRs, thermalRp, thermalC);
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setLimit(this.descriptor.thermalWarmLimit, this.descriptor.thermalCoolLimit).set(new WorldExplosion(this).cableExplosion());
        this.resistorProcess = new ResistorProcess(this, this.r, this.thermalLoad, this.descriptor);
        if (this.descriptor.tempCoef != 0.0 || this.descriptor.isRheostat) {
            this.slowProcessList.add(this.resistorProcess);
        }
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            if (this.descriptor.isRheostat) {
                stream.writeFloat((float)this.control.getNormalized());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (lrdu == this.front.right()) {
            return this.aLoad;
        }
        if (lrdu == this.front.left()) {
            return this.bLoad;
        }
        if (lrdu == this.front) {
            return this.control;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (lrdu == this.front.right() || lrdu == this.front.left()) {
            return 1;
        }
        if (lrdu == this.front && this.descriptor.isRheostat) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        double u = -Math.abs(this.aLoad.getU() - this.bLoad.getU());
        double i = Math.abs(this.r.getI());
        return Utils.plotOhm(Utils.plotUIP(u, i), this.r.getR()) + (this.control != null ? Utils.plotPercent("C", this.control.getNormalized()) : "");
    }

    @Override
    public String thermoMeterString() {
        return Utils.plotCelsius("T", this.thermalLoad.Tc);
    }

    @Override
    public void initialize() {
        this.setupPhysical();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.setupPhysical();
    }

    public void setupPhysical() {
        this.nominalRs = this.descriptor.getRsValue(this.inventory);
        this.resistorProcess.process(0.0);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new ResistorContainer(player, this.inventory);
    }
}

