/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalcable;

import java.util.Collections;
import java.util.List;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sim.ThermalLoad;
import mods.eln.sixnode.thermalcable.ThermalCableElement;
import mods.eln.sixnode.thermalcable.ThermalCableRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ThermalCableDescriptor
extends SixNodeDescriptor {
    boolean addToDataEnabled = true;
    double thermalRp = 1.0;
    double thermalRs = 1.0;
    double thermalC = 1.0;
    double thermalWarmLimit;
    double thermalCoolLimit;
    double thermalStdT;
    double thermalStdPower;
    double thermalStdDrop;
    double thermalStdLost;
    double thermalTao;
    String description = "todo cable";
    public CableRenderDescriptor render;
    public static final ThermalCableDescriptor[] list = new ThermalCableDescriptor[256];

    public ThermalCableDescriptor(String name, double thermalWarmLimit, double thermalCoolLimit, double thermalStdT, double thermalStdPower, double thermalStdDrop, double thermalStdLost, double thermalTao, CableRenderDescriptor render, String description) {
        super(name, ThermalCableElement.class, ThermalCableRender.class);
        this.description = description;
        this.render = render;
        this.thermalWarmLimit = thermalWarmLimit;
        this.thermalCoolLimit = thermalCoolLimit;
        this.thermalStdT = thermalStdT;
        this.thermalStdPower = thermalStdPower;
        this.thermalStdDrop = thermalStdDrop;
        this.thermalStdLost = thermalStdLost;
        this.thermalTao = thermalTao;
        this.thermalRs = thermalStdDrop / 2.0 / thermalStdPower;
        this.thermalRp = thermalStdT / thermalStdLost;
        this.thermalC = Eln.simulator.getMinimalThermalC(this.thermalRs, this.thermalRp);
        if (!Eln.simulator.checkThermalLoad(this.thermalRs, this.thermalRp, this.thermalC)) {
            Utils.println("Bad thermalCable setup");
            while (true) {
                // Infinite loop
            }
        }
        this.voltageLevelColor = VoltageLevelColor.Thermal;
    }

    public void addToData(boolean enable) {
        this.addToDataEnabled = enable;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        if (this.addToDataEnabled) {
            Data.addWiring(this.newItemStack());
            Data.addThermal(this.newItemStack());
        }
    }

    public static ThermalCableDescriptor getDescriptorFrom(ItemStack itemStack) {
        return list[itemStack.func_77960_j() >> 8 & 0xFF];
    }

    public void setThermalLoad(ThermalLoad thermalLoad) {
        thermalLoad.Rp = this.thermalRp;
        thermalLoad.Rs = this.thermalRs;
        thermalLoad.C = this.thermalC;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Max. temperature: %1$\u00b0C", this.thermalWarmLimit));
        list.add(I18N.tr("Serial resistance: %1$K/W", this.thermalRs * 2.0));
        list.add(I18N.tr("Parallel resistance: %1$K/W", this.thermalRp));
        list.add("");
        Collections.addAll(list, I18N.tr("Low serial resistance\n => High conductivity.", new Object[0]).split("\n"));
        Collections.addAll(list, I18N.tr("High parallel resistance\n => Low power dissipation.", new Object[0]).split("\n"));
    }
}

