/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalsensor;

import java.text.NumberFormat;
import java.text.ParseException;
import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.HelperStdContainer;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.thermalsensor.ThermalSensorContainer;
import mods.eln.sixnode.thermalsensor.ThermalSensorRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class ThermalSensorGui
extends GuiContainerEln {
    GuiButton validate;
    GuiButton temperatureType;
    GuiButton powerType;
    GuiTextFieldEln lowValue;
    GuiTextFieldEln highValue;
    ThermalSensorRender render;

    public ThermalSensorGui(EntityPlayer player, IInventory inventory, ThermalSensorRender render) {
        super(new ThermalSensorContainer(player, inventory));
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.render.descriptor.temperatureOnly) {
            this.powerType = this.newGuiButton(8, 8, 70, I18N.tr("Power", new Object[0]));
            this.temperatureType = this.newGuiButton(98, 8, 70, I18N.tr("Temperature", new Object[0]));
            int x = -15;
            int y = 13;
            this.validate = this.newGuiButton(x + 8 + 50 + 4 + 50 + 4 - 26, y + 41 - 8, 50, I18N.tr("Validate", new Object[0]));
            this.lowValue = this.newGuiTextField(x + 8 + 50 + 4 - 26, y + 41 + 3, 50);
            this.lowValue.setText(this.render.lowValue);
            this.lowValue.setComment(I18N.tr("Measured value\ncorresponding\nto 0% output", new Object[0]).split("/n"));
            this.highValue = this.newGuiTextField(x + 8 + 50 + 4 - 26, y + 41 - 12, 50);
            this.highValue.setText(this.render.highValue);
            this.highValue.setComment(I18N.tr("Measured value\ncorresponding\nto 100% output", new Object[0]).split("\n"));
        } else {
            int x = 0;
            int y = 0;
            this.validate = this.newGuiButton(x + 8 + 50 + 4 + 50 + 4 - 26, y + 41 - 8, 50, I18N.tr("Validate", new Object[0]));
            this.lowValue = this.newGuiTextField(x + 8 + 50 + 4 - 26, y + 41 + 3, 50);
            this.lowValue.setText(this.render.lowValue);
            this.lowValue.setComment(I18N.tr("Measured temperature\ncorresponding\nto 0% output", new Object[0]).split("/n"));
            this.highValue = this.newGuiTextField(x + 8 + 50 + 4 - 26, y + 41 - 12, 50);
            this.highValue.setText(this.render.highValue);
            this.highValue.setComment(I18N.tr("Measured temperature\ncorresponding\nto 100% output", new Object[0]).split("/n"));
        }
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.validate) {
            try {
                float lowVoltage = NumberFormat.getInstance().parse(this.lowValue.func_146179_b()).floatValue();
                float highVoltage = NumberFormat.getInstance().parse(this.highValue.func_146179_b()).floatValue();
                this.render.clientSetFloat(2, lowVoltage - 20.0f, highVoltage - 20.0f);
            }
            catch (ParseException parseException) {}
        } else if (object == this.temperatureType) {
            this.render.clientSetByte((byte)1, (byte)1);
        } else if (object == this.powerType) {
            this.render.clientSetByte((byte)1, (byte)0);
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        if (!this.render.descriptor.temperatureOnly) {
            if (this.render.typeOfSensor == 1) {
                this.powerType.field_146124_l = true;
                this.temperatureType.field_146124_l = false;
            } else if (this.render.typeOfSensor == 0) {
                this.powerType.field_146124_l = false;
                this.temperatureType.field_146124_l = true;
            }
        }
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new HelperStdContainer((GuiScreen)this);
    }
}

