/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalsensor;

import mods.eln.sim.IProcess;
import mods.eln.sixnode.thermalsensor.ThermalSensorElement;

public class ThermalSensorProcess
implements IProcess {
    ThermalSensorElement sensor;

    public ThermalSensorProcess(ThermalSensorElement sensor) {
        this.sensor = sensor;
    }

    @Override
    public void process(double time) {
        if (this.sensor.typeOfSensor == 1) {
            this.setOutput(this.sensor.thermalLoad.Tc);
        } else if (this.sensor.typeOfSensor == 0) {
            this.setOutput(this.sensor.thermalLoad.getPower());
        }
    }

    void setOutput(double physical) {
        double U = (physical - (double)this.sensor.lowValue) / (double)(this.sensor.highValue - this.sensor.lowValue) * 50.0;
        if (U > 50.0) {
            U = 50.0;
        }
        if (U < 0.0) {
            U = 0.0;
        }
        this.sensor.outputGateProcess.setU(U);
    }
}

