/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalsensor;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.thermalcable.ThermalCableDescriptor;
import mods.eln.sixnode.thermalsensor.ThermalSensorDescriptor;
import mods.eln.sixnode.thermalsensor.ThermalSensorGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ThermalSensorRender
extends SixNodeElementRender {
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    ThermalSensorDescriptor descriptor;
    long time;
    LRDU front;
    int typeOfSensor = 0;
    float lowValue = 0.0f;
    float highValue = 50.0f;
    ThermalCableDescriptor cable;
    ElectricalCableDescriptor ecable;

    public ThermalSensorRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ThermalSensorDescriptor)descriptor;
        this.time = System.currentTimeMillis();
    }

    @Override
    public void draw() {
        super.draw();
        this.front.glRotateOnX();
        this.descriptor.draw(this.ecable != null);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.front = LRDU.fromInt(b >> 4 & 3);
            this.typeOfSensor = b & 3;
            this.lowValue = (float)((double)stream.readFloat() + 20.0);
            this.highValue = (float)((double)stream.readFloat() + 20.0);
            ItemStack stack = Utils.unserialiseItemStack(stream);
            GenericItemBlockUsingDamageDescriptor desc = ThermalCableDescriptor.getDescriptor(stack);
            this.cable = desc instanceof ThermalCableDescriptor ? (ThermalCableDescriptor)desc : null;
            this.ecable = desc instanceof ElectricalCableDescriptor ? (ElectricalCableDescriptor)desc : null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ThermalSensorGui(player, this.inventory, this);
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        if (!this.descriptor.temperatureOnly) {
            if (this.front.left() == lrdu && this.cable != null) {
                return this.cable.render;
            }
            if (this.front.right() == lrdu && this.cable != null) {
                return this.cable.render;
            }
            if (this.front == lrdu) {
                return Eln.instance.signalCableDescriptor.render;
            }
        } else {
            if (this.front.inverse() == lrdu && this.cable != null) {
                return this.cable.render;
            }
            if (this.front.inverse() == lrdu && this.ecable != null) {
                return this.ecable.render;
            }
            if (this.front == lrdu) {
                return Eln.instance.signalCableDescriptor.render;
            }
        }
        return null;
    }
}

