/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.tutorialsign;

import java.util.List;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.tutorialsign.TutorialSignElement;
import mods.eln.sixnode.tutorialsign.TutorialSignRender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TutorialSignDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart light;
    private Obj3D.Obj3DPart halo;

    public TutorialSignDescriptor(String name, Obj3D obj) {
        super(name, TutorialSignElement.class, TutorialSignRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.light = obj.getPart("light");
            this.halo = obj.getPart("halo");
        }
    }

    void setupColor(float factor, float alpha) {
        if ((double)factor < 0.5) {
            float factorN = 1.0f - (factor *= 2.0f);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)(0.4f * factorN), (float)alpha);
        } else {
            factor = (factor - 0.5f) * 2.0f;
            float factorN = 1.0f - factor;
            GL11.glColor4f((float)0.0f, (float)(1.0f * factor), (float)0.0f, (float)alpha);
        }
    }

    @Override
    public boolean use2DIcon() {
        return false;
    }

    void draw(float factor) {
        if (this.main != null) {
            this.main.draw();
        }
        UtilsClient.disableLight();
        this.setupColor(factor, 1.0f);
        if (this.light != null) {
            this.light.draw();
        }
        UtilsClient.enableBlend();
        this.setupColor(factor, 0.4f);
        if (this.halo != null) {
            this.halo.draw();
        }
        UtilsClient.disableBlend();
        UtilsClient.enableLight();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.draw(1.0f);
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
    }
}

