/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mods.eln.misc.Coordonate;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalSpot;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxElement;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class WirelessUtils {
    private WirelessUtils() {
    }

    public static void getTx(IWirelessSignalSpot root, HashMap<String, HashSet<IWirelessSignalTx>> txSet, HashMap<IWirelessSignalTx, Double> txStrength) {
        HashSet<IWirelessSignalSpot> spotSet = new HashSet<IWirelessSignalSpot>();
        txSet.clear();
        txStrength.clear();
        WirelessUtils.getTx(root, txSet, txStrength, spotSet, true, 0.0);
    }

    private static void getTx(IWirelessSignalSpot from, HashMap<String, HashSet<IWirelessSignalTx>> txSet, HashMap<IWirelessSignalTx, Double> txStrength, HashSet<IWirelessSignalSpot> spotSet, boolean isRoot, double strength) {
        if (spotSet.contains(from)) {
            return;
        }
        spotSet.add(from);
        if (!isRoot) {
            for (List list : from.getTx().values()) {
                for (IWirelessSignalTx tx : list) {
                    if (isRoot) {
                        strength = (double)tx.getRange() - WirelessUtils.getVirtualDistance(tx.getCoordonate(), from.getCoordonate(), tx.getCoordonate().trueDistanceTo(from.getCoordonate()));
                    }
                    WirelessUtils.addTo(tx, strength, txSet, txStrength);
                }
            }
            for (IWirelessSignalSpot iWirelessSignalSpot : from.getSpot()) {
                if (isRoot) {
                    strength = (double)iWirelessSignalSpot.getRange() - WirelessUtils.getVirtualDistance(iWirelessSignalSpot.getCoordonate(), from.getCoordonate(), iWirelessSignalSpot.getCoordonate().trueDistanceTo(from.getCoordonate()));
                }
                WirelessUtils.getTx(iWirelessSignalSpot, txSet, txStrength, spotSet, false, strength);
            }
        } else {
            LinkedList<IWirelessSignalSpot> spots = new LinkedList<IWirelessSignalSpot>();
            spots.addAll(from.getSpot());
            LinkedList<IWirelessSignalTx> linkedList = new LinkedList<IWirelessSignalTx>();
            for (ArrayList<IWirelessSignalTx> txss : from.getTx().values()) {
                linkedList.addAll(txss);
            }
            Object best = null;
            while (!spots.isEmpty() || !linkedList.isEmpty()) {
                double temp;
                double bestScore = Double.MAX_VALUE;
                for (IWirelessSignalSpot spot : spots) {
                    temp = spot.getCoordonate().trueDistanceTo(from.getCoordonate());
                    if (!(temp < bestScore)) continue;
                    bestScore = temp;
                    best = spot;
                }
                for (IWirelessSignalTx tx : linkedList) {
                    temp = tx.getCoordonate().trueDistanceTo(from.getCoordonate());
                    if (!(temp < bestScore)) continue;
                    bestScore = temp;
                    best = tx;
                }
                if (best instanceof IWirelessSignalSpot) {
                    IWirelessSignalSpot b = (IWirelessSignalSpot)best;
                    if (isRoot) {
                        strength = (double)b.getRange() - WirelessUtils.getVirtualDistance(b.getCoordonate(), from.getCoordonate(), b.getCoordonate().trueDistanceTo(from.getCoordonate()));
                    }
                    WirelessUtils.getTx(b, txSet, txStrength, spotSet, false, strength);
                    spots.remove(best);
                    continue;
                }
                if (best != null) {
                    IWirelessSignalTx tx = (IWirelessSignalTx)best;
                    if (isRoot) {
                        strength = (double)tx.getRange() - WirelessUtils.getVirtualDistance(tx.getCoordonate(), from.getCoordonate(), tx.getCoordonate().trueDistanceTo(from.getCoordonate()));
                    }
                    WirelessUtils.addTo(tx, strength, txSet, txStrength);
                    linkedList.remove(best);
                    continue;
                }
                break;
            }
        }
    }

    private static void addTo(IWirelessSignalTx tx, double strength, Map<String, HashSet<IWirelessSignalTx>> reg, Map<IWirelessSignalTx, Double> txStrength) {
        String channel = tx.getChannel();
        HashSet<IWirelessSignalTx> ch = reg.get(channel);
        if (ch != null && ch.contains(tx)) {
            return;
        }
        if (ch == null) {
            ch = new HashSet();
            reg.put(channel, ch);
        }
        ch.add(tx);
        txStrength.put(tx, strength);
    }

    public static WirelessSignalSpot buildSpot(Coordonate c, String channel, int range) {
        HashMap<String, ArrayList<IWirelessSignalTx>> txs = new HashMap<String, ArrayList<IWirelessSignalTx>>();
        ArrayList<IWirelessSignalSpot> spots = new ArrayList<IWirelessSignalSpot>();
        for (IWirelessSignalSpot iWirelessSignalSpot : IWirelessSignalSpot.spots) {
            if (!WirelessUtils.isInRange(iWirelessSignalSpot.getCoordonate(), c, iWirelessSignalSpot.getRange())) continue;
            spots.add(iWirelessSignalSpot);
        }
        if (channel != null) {
            ArrayList<IWirelessSignalTx> inRangeTx = new ArrayList<IWirelessSignalTx>();
            List list = WirelessSignalTxElement.channelMap.get(channel);
            if (list != null) {
                for (IWirelessSignalTx tx : list) {
                    if (!WirelessUtils.isInRange(tx.getCoordonate(), c, tx.getRange())) continue;
                    inRangeTx.add(tx);
                }
            }
            if (!inRangeTx.isEmpty()) {
                txs.put(channel, inRangeTx);
            }
        } else {
            for (Map.Entry entry : WirelessSignalTxElement.channelMap.entrySet()) {
                ArrayList<IWirelessSignalTx> inRangeTx = new ArrayList<IWirelessSignalTx>();
                for (IWirelessSignalTx tx : (ArrayList)entry.getValue()) {
                    if (!WirelessUtils.isInRange(tx.getCoordonate(), c, tx.getRange())) continue;
                    inRangeTx.add(tx);
                }
                if (inRangeTx.isEmpty()) continue;
                txs.put((String)entry.getKey(), inRangeTx);
            }
        }
        return new WirelessSignalSpot(txs, spots, c, range);
    }

    private static boolean isInRange(Coordonate txC, Coordonate rxC, double range) {
        double distance = txC.trueDistanceTo(rxC);
        if (distance > range) {
            return false;
        }
        return !(WirelessUtils.getVirtualDistance(txC, rxC, distance) > range);
    }

    private static double getVirtualDistance(Coordonate txC, Coordonate rxC, double distance) {
        double virtualDistance = distance;
        if (distance > 2.0) {
            double vx = (double)rxC.x + 0.5;
            double vy = (double)rxC.y + 0.5;
            double vz = (double)rxC.z + 0.5;
            double dx = (double)(txC.x - rxC.x) / distance;
            double dy = (double)(txC.y - rxC.y) / distance;
            double dz = (double)(txC.z - rxC.z) / distance;
            Coordonate c = new Coordonate();
            c.setDimention(rxC.dimention);
            int idx = 0;
            while ((double)idx < distance - 1.0) {
                Block b;
                c.x = (int)(vx += dx);
                c.y = (int)(vy += dy);
                c.z = (int)(vz += dz);
                if (c.getBlockExist() && (b = c.getBlock()) != Blocks.field_150350_a && b.func_149662_c()) {
                    virtualDistance += 2.0;
                }
                ++idx;
            }
        }
        return virtualDistance;
    }

    public static class WirelessSignalSpot
    implements IWirelessSignalSpot {
        HashMap<String, ArrayList<IWirelessSignalTx>> txs;
        ArrayList<IWirelessSignalSpot> spots;
        Coordonate coordonate;
        int range;

        public WirelessSignalSpot(HashMap<String, ArrayList<IWirelessSignalTx>> txs, ArrayList<IWirelessSignalSpot> spots, Coordonate coordonate, int range) {
            this.txs = txs;
            this.spots = spots;
            this.coordonate = coordonate;
            this.range = range;
        }

        @Override
        public HashMap<String, ArrayList<IWirelessSignalTx>> getTx() {
            return this.txs;
        }

        @Override
        public ArrayList<IWirelessSignalSpot> getSpot() {
            return this.spots;
        }

        @Override
        public Coordonate getCoordonate() {
            return this.coordonate;
        }

        @Override
        public int getRange() {
            return this.range;
        }
    }
}

