/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal.source;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.source.WirelessSignalSourceDescriptor;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxElement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class WirelessSignalSourceElement
extends SixNodeElement
implements IWirelessSignalTx {
    public static final HashMap<String, ArrayList<IWirelessSignalTx>> channelMap = new HashMap();
    WirelessSignalSourceDescriptor descriptor;
    public AutoResetProcess autoResetProcess;
    boolean state = false;
    public String channel = "Default channel";
    private WirelessSignalTxElement.LightningGlitchProcess lightningGlitchProcess;
    public static final byte setChannelId = 1;

    public WirelessSignalSourceElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (WirelessSignalSourceDescriptor)descriptor;
        WirelessSignalTxElement.channelRegister(this);
        this.lightningGlitchProcess = new WirelessSignalTxElement.LightningGlitchProcess(this.getCoordonate());
        this.slowProcessList.add(this.lightningGlitchProcess);
        if (this.descriptor.autoReset) {
            this.autoResetProcess = new AutoResetProcess();
            this.slowProcessList.add(this.autoResetProcess);
            this.autoResetProcess.reset();
        }
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        return 0;
    }

    @Override
    public String multiMeterString() {
        return null;
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            return false;
        }
        boolean bl = this.state = !this.state;
        if (this.state && this.autoResetProcess != null) {
            this.autoResetProcess.reset();
        }
        this.needPublish();
        return true;
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        WirelessSignalTxElement.channelRemove(this);
        super.destroy(entityPlayer);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("channel", this.channel);
        nbt.func_74757_a("state", this.state);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        WirelessSignalTxElement.channelRemove(this);
        super.readFromNBT(nbt);
        this.channel = nbt.func_74779_i("channel");
        this.state = nbt.func_74767_n("state");
        WirelessSignalTxElement.channelRegister(this);
    }

    @Override
    public Coordonate getCoordonate() {
        return this.sixNode.coordonate;
    }

    @Override
    public int getRange() {
        return this.descriptor.range;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public double getValue() {
        return (this.state ? 1.0 : 0.0) + this.lightningGlitchProcess.glitchOffset;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    WirelessSignalTxElement.channelRemove(this);
                    this.channel = stream.readUTF();
                    this.needPublish();
                    WirelessSignalTxElement.channelRegister(this);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.channel);
            stream.writeBoolean(this.state);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class AutoResetProcess
    implements IProcess {
        double timeout = 0.0;
        double timeoutDelay = 0.21;

        AutoResetProcess() {
        }

        @Override
        public void process(double time) {
            if (this.timeout > 0.0) {
                if (this.timeout - time < 0.0 && WirelessSignalSourceElement.this.state) {
                    WirelessSignalSourceElement.this.state = false;
                    WirelessSignalSourceElement.this.needPublish();
                }
                this.timeout -= time;
            }
        }

        void reset() {
            this.timeout = this.timeoutDelay;
        }
    }
}

