/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal.source;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.wirelesssignal.source.WirelessSignalSourceDescriptor;
import mods.eln.sixnode.wirelesssignal.source.WirelessSignalSourceGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class WirelessSignalSourceRender
extends SixNodeElementRender {
    WirelessSignalSourceDescriptor descriptor;
    RcInterpolator interpolator;
    String channel;
    boolean state = false;

    public WirelessSignalSourceRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (WirelessSignalSourceDescriptor)descriptor;
        this.interpolator = new RcInterpolator(this.descriptor.render.speed);
    }

    @Override
    public void draw() {
        super.draw();
        this.descriptor.draw(this.interpolator.get(), UtilsClient.distanceFromClientPlayer(this.tileEntity), this.tileEntity);
    }

    @Override
    public void refresh(float deltaT) {
        this.interpolator.setTarget(this.state ? 1 : 0);
        this.interpolator.step(deltaT);
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new WirelessSignalSourceGui(this);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.channel = stream.readUTF();
            this.state = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

