/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.solver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import mods.eln.Eln;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.INBTTReady;
import mods.eln.sim.IProcess;
import mods.eln.solver.Constant;
import mods.eln.solver.IOperator;
import mods.eln.solver.IOperatorMapper;
import mods.eln.solver.ISymbole;
import mods.eln.solver.IValue;
import mods.eln.solver.OperatorAB;
import mods.eln.solver.OperatorMapperA;
import mods.eln.solver.OperatorMapperAB;
import mods.eln.solver.OperatorMapperBracket;
import mods.eln.solver.OperatorMapperFunc;
import net.minecraft.nbt.NBTTagCompound;

public class Equation
implements IValue,
INBTTReady {
    LinkedList<String> stringList = new LinkedList();
    ArrayList<INBTTReady> nbtList = new ArrayList();
    static final HashMap<Integer, ArrayList<IOperatorMapper>> staticOperatorList;
    HashMap<Integer, ArrayList<IOperatorMapper>> operatorList;
    static final String staticSeparatorList;
    String separatorList = "";
    int iterationLimit;
    ArrayList<ISymbole> symbolList;
    IValue root;
    ArrayList<IProcess> processList = new ArrayList();
    int operatorCount;

    public Equation() {
        this.operatorList = new HashMap();
        this.symbolList = new ArrayList();
    }

    public void setUpDefaultOperatorAndMapper() {
        this.operatorList.putAll(staticOperatorList);
        this.separatorList = this.separatorList + staticSeparatorList;
    }

    public void addMapper(int priority, IOperatorMapper mapper) {
        ArrayList<IOperatorMapper> list = this.operatorList.get(priority);
        if (list == null) {
            list = new ArrayList();
            this.operatorList.put(priority, list);
        }
        list.add(mapper);
    }

    public void setIterationLimit(int iterationLimit) {
        this.iterationLimit = iterationLimit;
    }

    public void addSymbol(ArrayList<ISymbole> symbolList) {
        this.symbolList.addAll(symbolList);
    }

    public void preProcess(String exp) {
        int idx;
        exp = exp.replace(" ", "");
        this.stringList.clear();
        LinkedList<Object> list = new LinkedList<Object>();
        String stack = "";
        for (idx = 0; idx != exp.length(); ++idx) {
            if (this.separatorList.contains(exp.subSequence(idx, idx + 1))) {
                if (stack != "") {
                    list.add(stack);
                    this.stringList.add(stack);
                    stack = "";
                }
                list.add(exp.substring(idx, idx + 1));
                continue;
            }
            stack = stack + exp.charAt(idx);
        }
        if (stack != "") {
            list.add(stack);
            this.stringList.add(stack);
        }
        int depthMax = this.getDepthMax(list);
        idx = 0;
        for (Object e : list) {
            if (e instanceof String) {
                String str = (String)e;
                boolean find = false;
                if (!find) {
                    for (ISymbole s : this.symbolList) {
                        if (!s.getName().equals(str)) continue;
                        list.set(idx, s);
                        find = true;
                    }
                }
                if (!find) {
                    try {
                        double value = Double.parseDouble(str);
                        list.set(idx, new Constant(value));
                        find = true;
                    }
                    catch (NumberFormatException value) {
                        // empty catch block
                    }
                }
                if (!find && (str.equals("PI") || str.equals("pi"))) {
                    list.set(idx, new Constant(Math.PI));
                }
            }
            ++idx;
        }
        int priority = -1;
        block5: while (list.size() > 1 && this.iterationLimit != 0) {
            --this.iterationLimit;
            idx = 0;
            int depth = 0;
            Iterator i = list.iterator();
            ++priority;
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof String) {
                    String str = (String)o;
                    if (this.operatorList.containsKey(priority)) {
                        int depthDelta = depth - depthMax;
                        boolean resetPriority = false;
                        for (IOperatorMapper mapper : this.operatorList.get(priority)) {
                            IOperator operator = mapper.newOperator(str, depthDelta, list, idx);
                            if (operator == null) continue;
                            if (operator instanceof IProcess) {
                                this.processList.add((IProcess)((Object)operator));
                            }
                            if (operator instanceof INBTTReady) {
                                this.nbtList.add((INBTTReady)((Object)operator));
                            }
                            this.operatorCount += operator.getRedstoneCost();
                            resetPriority = true;
                            break;
                        }
                        if (resetPriority) {
                            depthMax = this.getDepthMax(list);
                            priority = -1;
                            continue block5;
                        }
                    }
                    if (str.equals("(")) {
                        ++depth;
                    }
                    if (str.equals(")")) {
                        --depth;
                    }
                }
                ++idx;
            }
        }
        if (list.size() == 1) {
            this.root = list.get(0) instanceof IValue ? (IValue)list.get(0) : null;
        }
    }

    int getDepthMax(LinkedList<Object> list) {
        int depthMax = 0;
        int depth = 0;
        for (Object e : list) {
            if (!(e instanceof String)) continue;
            String str = (String)e;
            if (str.equals("(")) {
                ++depth;
            }
            if (str.equals(")")) {
                --depth;
            }
            depthMax = Math.max(depthMax, depth);
        }
        return depthMax;
    }

    @Override
    public double getValue() {
        if (this.root == null) {
            return 0.0;
        }
        return this.root.getValue();
    }

    public double getValue(double deltaT) {
        if (this.root == null) {
            return 0.0;
        }
        for (IProcess p : this.processList) {
            p.process(deltaT);
        }
        return this.root.getValue();
    }

    public boolean isValid() {
        return this.root != null;
    }

    public boolean isSymboleUsed(ISymbole iSymbole) {
        if (!this.isValid()) {
            return false;
        }
        return this.stringList.contains(iSymbole.getName());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        if (!this.isValid()) {
            return;
        }
        int idx = 0;
        for (INBTTReady o : this.nbtList) {
            o.readFromNBT(nbt, str + idx);
            ++idx;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        if (!this.isValid()) {
            return;
        }
        int idx = 0;
        for (INBTTReady o : this.nbtList) {
            o.writeToNBT(nbt, str + idx);
            ++idx;
        }
    }

    public int getOperatorCount() {
        return this.operatorCount;
    }

    static {
        staticSeparatorList = "+-*&|/^,()<>=";
        staticOperatorList = new HashMap();
        int priority = 0;
        ArrayList<IOperatorMapper> list = new ArrayList<IOperatorMapper>();
        list.add(new OperatorMapperFunc("min", 2, Min.class));
        list.add(new OperatorMapperFunc("max", 2, Max.class));
        list.add(new OperatorMapperFunc("sin", 1, Sin.class));
        list.add(new OperatorMapperFunc("cos", 1, Cos.class));
        list.add(new OperatorMapperFunc("asin", 1, Asin.class));
        list.add(new OperatorMapperFunc("acos", 1, Acos.class));
        list.add(new OperatorMapperFunc("abs", 1, Abs.class));
        list.add(new OperatorMapperFunc("ramp", 1, Ramp.class));
        list.add(new OperatorMapperFunc("integrate", 2, Integrator.class));
        list.add(new OperatorMapperFunc("integrate", 3, IntegratorMinMax.class));
        list.add(new OperatorMapperFunc("derivate", 1, Derivator.class));
        list.add(new OperatorMapperFunc("pow", 2, Pow.class));
        list.add(new OperatorMapperFunc("pid", 5, Pid.class));
        list.add(new OperatorMapperFunc("pid", 7, PidMinMax.class));
        list.add(new OperatorMapperFunc("batteryCharge", 1, BatteryCharge.class));
        list.add(new OperatorMapperFunc("rs", 2, Rs.class));
        list.add(new OperatorMapperFunc("rc", 2, RC.class));
        list.add(new OperatorMapperFunc("if", 3, If.class));
        list.add(new OperatorMapperFunc("scale", 5, Scale.class));
        list.add(new OperatorMapperBracket());
        staticOperatorList.put(priority++, list);
        list = new ArrayList();
        staticOperatorList.put(priority++, list);
        list = new ArrayList();
        list.add(new OperatorMapperA("-", Inv.class));
        list.add(new OperatorMapperAB("*", Mul.class));
        list.add(new OperatorMapperAB("/", Div.class));
        staticOperatorList.put(priority++, list);
        list = new ArrayList();
        list.add(new OperatorMapperAB("+", Add.class));
        list.add(new OperatorMapperAB("-", Sub.class));
        staticOperatorList.put(priority++, list);
        list = new ArrayList();
        list.add(new OperatorMapperAB(">", Bigger.class));
        list.add(new OperatorMapperAB("<", Smaller.class));
        staticOperatorList.put(priority++, list);
        list = new ArrayList();
        list.add(new OperatorMapperAB("=", Eguals.class));
        list.add(new OperatorMapperAB("^", NotEguals.class));
        list.add(new OperatorMapperAB("&", And.class));
        list.add(new OperatorMapperAB("|", Or.class));
        staticOperatorList.put(priority++, list);
    }

    public static class Scale
    implements IOperator {
        private IValue x;
        private IValue in0;
        private IValue in1;
        private IValue out0;
        private IValue out1;

        @Override
        public void setOperator(IValue[] values) {
            this.x = values[0];
            this.in0 = values[1];
            this.in1 = values[2];
            this.out0 = values[3];
            this.out1 = values[4];
        }

        @Override
        public int getRedstoneCost() {
            return 5;
        }

        @Override
        public double getValue() {
            double xv = this.x.getValue();
            double in0v = this.in0.getValue();
            double in1v = this.in1.getValue();
            double out0v = this.out0.getValue();
            double out1v = this.out1.getValue();
            return (xv - in0v) / (in1v - in0v) * (out1v - out0v) + out0v;
        }
    }

    public static class BatteryCharge
    implements IOperator {
        double eMax;
        public IValue probe;

        public BatteryCharge() {
            FunctionTable uFq = Eln.instance.batteryVoltageFunctionTable;
            double dq = 0.01;
            this.eMax = 0.0;
            for (double q = 0.0; q <= 1.0; q += dq) {
                this.eMax += uFq.getValue(q) * dq;
            }
        }

        @Override
        public void setOperator(IValue[] values) {
            this.probe = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 8;
        }

        @Override
        public double getValue() {
            FunctionTable uFq = Eln.instance.batteryVoltageFunctionTable;
            double probeU = this.probe.getValue();
            if (probeU > 1.5) {
                return 1.0;
            }
            double q = 0.0;
            double dq = 0.01;
            double e = 0.0;
            while (true) {
                double d;
                double u = uFq.getValue(q);
                if (!(d < probeU)) break;
                e += u * dq;
                q += dq;
            }
            return e / this.eMax;
        }
    }

    public static class If
    implements IOperator {
        public IValue condition;
        public IValue thenValue;
        public IValue elseValue;

        @Override
        public double getValue() {
            return this.condition.getValue() > 0.5 ? this.thenValue.getValue() : this.elseValue.getValue();
        }

        @Override
        public void setOperator(IValue[] values) {
            this.condition = values[0];
            this.thenValue = values[1];
            this.elseValue = values[2];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class RC
    implements IOperator,
    INBTTReady,
    IProcess {
        public double state;
        public IValue tao;
        public IValue input;

        @Override
        public double getValue() {
            return this.state;
        }

        @Override
        public void process(double time) {
            double tao = Math.max(time, this.tao.getValue());
            this.state += (this.input.getValue() - this.state) / tao * time;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.state = nbt.func_74769_h(str + "state");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74780_a(str + "state", this.state);
        }

        @Override
        public void setOperator(IValue[] values) {
            this.input = values[1];
            this.tao = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 3;
        }
    }

    public static class Rs
    implements IOperator,
    INBTTReady {
        public boolean state = false;
        public IValue set;
        public IValue reset;

        @Override
        public double getValue() {
            if (this.set.getValue() > 0.6) {
                this.state = true;
            }
            if (this.reset.getValue() > 0.6) {
                this.state = false;
            }
            return this.state ? 1.0 : 0.0;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.state = nbt.func_74767_n(str + "state");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74757_a(str + "state", this.state);
        }

        @Override
        public void setOperator(IValue[] values) {
            this.set = values[1];
            this.reset = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 3;
        }
    }

    public static class Max
    implements IOperator {
        public IValue a;
        public IValue b;

        @Override
        public double getValue() {
            return Math.max(this.a.getValue(), this.b.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[1];
            this.b = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class Min
    implements IOperator {
        public IValue a;
        public IValue b;

        @Override
        public double getValue() {
            return Math.min(this.a.getValue(), this.b.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[1];
            this.b = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class PidMinMax
    extends Pid {
        public IValue min;
        public IValue max;

        @Override
        public double getValue() {
            return Math.max(this.min.getValue(), Math.min(this.max.getValue(), super.getValue()));
        }

        @Override
        public void setOperator(IValue[] values) {
            super.setOperator(values);
            this.min = values[5];
            this.max = values[6];
        }

        @Override
        public int getRedstoneCost() {
            return super.getRedstoneCost() + 2;
        }
    }

    public static class Pid
    implements IOperator,
    INBTTReady,
    IProcess {
        public double iStack = 0.0;
        public double oldError = 0.0;
        public double dValue = 0.0;
        public IValue target;
        public IValue hit;
        public IValue p;
        public IValue i;
        public IValue d;

        @Override
        public double getValue() {
            double value = this.oldError * this.p.getValue() + this.iStack + this.dValue * this.d.getValue();
            return value;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.iStack = nbt.func_74769_h(str + "iStack");
            this.oldError = nbt.func_74769_h(str + "oldError");
            this.dValue = nbt.func_74769_h(str + "dValue");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74780_a(str + "iStack", this.iStack);
            nbt.func_74780_a(str + "oldError", this.oldError);
            nbt.func_74780_a(str + "dValue", this.dValue);
        }

        @Override
        public void process(double time) {
            double error = this.target.getValue() - this.hit.getValue();
            this.iStack += error * time * this.i.getValue();
            this.dValue = (error - this.oldError) / time;
            if (this.iStack > 1.0) {
                this.iStack = 1.0;
            }
            if (this.iStack < -1.0) {
                this.iStack = -1.0;
            }
            this.oldError = error;
        }

        @Override
        public void setOperator(IValue[] values) {
            this.target = values[0];
            this.hit = values[1];
            this.p = values[2];
            this.i = values[3];
            this.d = values[4];
        }

        @Override
        public int getRedstoneCost() {
            return 12;
        }
    }

    public static class Derivator
    implements IOperator,
    INBTTReady,
    IProcess {
        public double old = 0.0;
        public double value = 0.0;
        public IValue probe;

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.old = nbt.func_74769_h(str + "old");
            this.value = nbt.func_74769_h(str + "value");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74780_a(str + "old", this.old);
            nbt.func_74780_a(str + "value", this.value);
        }

        @Override
        public void process(double time) {
            double next = this.probe.getValue();
            this.value = (next - this.old) / time;
            this.old = next;
        }

        @Override
        public void setOperator(IValue[] values) {
            this.probe = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 3;
        }
    }

    public static class IntegratorMinMax
    implements IOperator,
    INBTTReady,
    IProcess {
        public double counter = 0.0;
        public IValue probe;
        public IValue min;
        public IValue max;

        @Override
        public double getValue() {
            return this.counter;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.counter = nbt.func_74769_h(str + "counter");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74780_a(str + "counter", this.counter);
        }

        @Override
        public void process(double time) {
            this.counter += time * this.probe.getValue();
            if (this.counter < this.min.getValue()) {
                this.counter = this.min.getValue();
            }
            if (this.counter > this.max.getValue()) {
                this.counter = this.max.getValue();
            }
        }

        @Override
        public void setOperator(IValue[] values) {
            this.probe = values[0];
            this.min = values[1];
            this.max = values[2];
        }

        @Override
        public int getRedstoneCost() {
            return 4;
        }
    }

    public static class Integrator
    implements IOperator,
    INBTTReady,
    IProcess {
        public double counter = 0.0;
        public IValue probe;
        public IValue reset;

        @Override
        public double getValue() {
            return this.counter;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.counter = nbt.func_74769_h(str + "counter");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74780_a(str + "counter", this.counter);
        }

        @Override
        public void process(double time) {
            this.counter += time * this.probe.getValue();
            if (this.reset.getValue() > 0.5) {
                this.counter = 0.0;
            }
        }

        @Override
        public void setOperator(IValue[] values) {
            this.probe = values[0];
            this.reset = values[1];
        }

        @Override
        public int getRedstoneCost() {
            return 4;
        }
    }

    public static class Ramp
    implements IOperator,
    INBTTReady,
    IProcess {
        public double counter = 0.0;
        public IValue periode;

        @Override
        public double getValue() {
            return this.counter;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.counter = nbt.func_74769_h(str + "counter");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74780_a(str + "counter", this.counter);
        }

        @Override
        public void process(double time) {
            double p = this.periode.getValue();
            this.counter += time / p;
            if (this.counter >= 1.0) {
                this.counter -= 1.0;
            }
            if (this.counter >= 1.0) {
                this.counter = 0.0;
            }
        }

        @Override
        public void setOperator(IValue[] values) {
            this.periode = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 3;
        }
    }

    public static class Pow
    implements IOperator {
        IValue a;
        IValue b;

        @Override
        public double getValue() {
            return Math.pow(this.a.getValue(), this.b.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
            this.b = values[1];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class Acos
    implements IOperator {
        IValue a;

        @Override
        public double getValue() {
            return Math.acos(this.a.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class Asin
    implements IOperator {
        IValue a;

        @Override
        public double getValue() {
            return Math.asin(this.a.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class Cos
    implements IOperator {
        IValue a;

        @Override
        public double getValue() {
            return Math.cos(this.a.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class Sin
    implements IOperator {
        IValue a;

        @Override
        public double getValue() {
            return Math.sin(this.a.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 2;
        }
    }

    public static class Abs
    implements IOperator {
        IValue a;

        @Override
        public double getValue() {
            return Math.abs(this.a.getValue());
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Bracket
    implements IOperator {
        IValue a;

        @Override
        public double getValue() {
            return this.a.getValue();
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 0;
        }
    }

    public static class Inv
    implements IOperator {
        IValue a;

        @Override
        public double getValue() {
            return -this.a.getValue();
        }

        @Override
        public void setOperator(IValue[] values) {
            this.a = values[0];
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Div
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() / this.b.getValue();
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Mul
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() * this.b.getValue();
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Sub
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() - this.b.getValue();
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Add
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() + this.b.getValue();
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Or
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() > 0.5 || this.b.getValue() > 0.5 ? 1.0 : 0.0;
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class And
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() > 0.5 && this.b.getValue() > 0.5 ? 1.0 : 0.0;
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Smaller
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() < this.b.getValue() ? 1.0 : 0.0;
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Bigger
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() > this.b.getValue() ? 1.0 : 0.0;
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class NotEguals
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() > 0.5 != this.b.getValue() > 0.5 ? 1.0 : 0.0;
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }

    public static class Eguals
    extends OperatorAB {
        @Override
        public double getValue() {
            return this.a.getValue() > 0.5 == this.b.getValue() > 0.5 ? 1.0 : 0.0;
        }

        @Override
        public int getRedstoneCost() {
            return 1;
        }
    }
}

