/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.solver;

import java.util.List;
import mods.eln.solver.IOperator;
import mods.eln.solver.IOperatorMapper;
import mods.eln.solver.IValue;

public class OperatorMapperFunc
implements IOperatorMapper {
    private Class operator;
    private String key;
    private int argCount;

    public OperatorMapperFunc(String key, int argCount, Class operator) {
        this.operator = operator;
        this.key = key;
        this.argCount = argCount;
    }

    @Override
    public IOperator newOperator(String key, int depthDelta, List<Object> arg, int argOffset) {
        if (depthDelta != -1) {
            return null;
        }
        if (!this.key.equals(key)) {
            return null;
        }
        if (!this.isFuncReady(arg, argOffset)) {
            return null;
        }
        try {
            IOperator o = (IOperator)this.operator.newInstance();
            IValue[] operatorArg = new IValue[this.argCount];
            for (int i = 0; i < this.argCount; ++i) {
                operatorArg[i] = (IValue)arg.get(argOffset + 2 * (i + 1));
            }
            o.setOperator(operatorArg);
            arg.set(argOffset, o);
            this.removeFunc(arg, argOffset);
            return o;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isFuncReady(List<Object> list, int argOffset) {
        int counter = 0;
        int end = ++argOffset + 2 + this.argCount * 2 - 1;
        while (argOffset < end) {
            if (argOffset >= list.size()) {
                return false;
            }
            Object o = list.get(argOffset);
            String str = null;
            if (o instanceof String) {
                str = (String)o;
            }
            if (counter == 0 ? str == null || !str.equals("(") : (argOffset == end - 1 ? str == null || !str.equals(")") : (counter % 2 == 1 ? !(o instanceof IValue) : str == null || !str.equals(",")))) {
                return false;
            }
            ++counter;
            ++argOffset;
        }
        return true;
    }

    private void removeFunc(List<Object> list, int offset) {
        for (int idx = 0; idx < 2 + this.argCount * 2 - 1; ++idx) {
            list.remove(offset + 1);
        }
    }
}

