/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sound;

import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.sound.IPlayer;
import mods.eln.sound.SoundCommand;

public abstract class SoundLooper
implements IProcess {
    IPlayer player;
    double loopTimeout = Math.random();
    boolean couldStop;
    int uuid;

    public SoundLooper(IPlayer player, boolean couldStop) {
        if (couldStop) {
            this.uuid = Utils.getUuid();
        }
        this.player = player;
        this.couldStop = couldStop;
    }

    public SoundLooper(IPlayer player) {
        this(player, false);
    }

    @Override
    public void process(double time) {
        SoundCommand track;
        if (this.loopTimeout > 0.0) {
            this.loopTimeout -= time;
        }
        if (this.loopTimeout <= 0.0 && (track = this.mustStart()) != null) {
            SoundCommand cmd = track.copy();
            if (this.couldStop) {
                cmd.addUuid(this.uuid);
            }
            this.player.play(cmd);
            this.loopTimeout = track.trackLength / (double)track.pitch;
        }
        if (this.couldStop && this.mustStop() && this.loopTimeout != 0.0) {
            this.loopTimeout = 0.0;
            this.player.stop(this.uuid);
        }
    }

    public abstract SoundCommand mustStart();

    public boolean mustStop() {
        return false;
    }
}

