/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataOutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ResistorHeatThermalLoad;
import mods.eln.sixnode.resistor.ResistorContainer;
import mods.eln.transparentnode.LargeRheostatDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001TB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\b\u00109\u001a\u00020\u001eH\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010:2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0014\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020=0<H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u0012\u0010B\u001a\u00020A2\b\u0010\u001d\u001a\u0004\u0018\u00010CH\u0016J\u0010\u0010D\u001a\u00020=2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010E\u001a\u00020A2\u0006\u0010F\u001a\u00020GH\u0016J\u001c\u0010H\u001a\u00020I2\b\u00103\u001a\u0004\u0018\u0001042\b\u0010J\u001a\u0004\u0018\u00010KH\u0016J4\u0010L\u001a\u00020?2\b\u0010M\u001a\u0004\u0018\u00010K2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020OH\u0016J\u0006\u0010R\u001a\u00020AJ\u0010\u0010S\u001a\u00020=2\u0006\u00103\u001a\u000204H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0011\u001a\u00060\u0012R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006U"}, d2={"Lmods/eln/transparentnode/LargeRheostatElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "aLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getALoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "bLoad", "getBLoad", "control", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getControl", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "controlProcess", "Lmods/eln/transparentnode/LargeRheostatElement$ControlProcess;", "getControlProcess", "()Lmods/eln/transparentnode/LargeRheostatElement$ControlProcess;", "desc", "Lmods/eln/transparentnode/LargeRheostatDescriptor;", "getDesc", "()Lmods/eln/transparentnode/LargeRheostatDescriptor;", "heater", "Lmods/eln/sim/process/heater/ResistorHeatThermalLoad;", "getHeater", "()Lmods/eln/sim/process/heater/ResistorHeatThermalLoad;", "inventory", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "nominalRs", "", "getNominalRs", "()D", "setNominalRs", "(D)V", "resistor", "Lmods/eln/sim/mna/component/Resistor;", "getResistor", "()Lmods/eln/sim/mna/component/Resistor;", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalWatchdog", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getInventory", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "", "initialize", "", "inventoryChange", "Lnet/minecraft/inventory/IInventory;", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "newContainer", "Lmods/eln/sixnode/resistor/ResistorContainer;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockActivated", "entityPlayer", "vx", "", "vy", "vz", "setupPhysical", "thermoMeterString", "ControlProcess", "ElectricalAge-release_main"})
public final class LargeRheostatElement
extends TransparentNodeElement {
    @NotNull
    private final LargeRheostatDescriptor desc;
    private double nominalRs;
    private TransparentNodeElementInventory inventory;
    @NotNull
    private final NbtElectricalLoad aLoad;
    @NotNull
    private final NbtElectricalLoad bLoad;
    @NotNull
    private final Resistor resistor;
    @NotNull
    private final NbtElectricalGateInput control;
    @NotNull
    private final ControlProcess controlProcess;
    @NotNull
    private final NbtThermalLoad thermalLoad;
    @NotNull
    private final ResistorHeatThermalLoad heater;
    @NotNull
    private final ThermalLoadWatchDog thermalWatchdog;

    @NotNull
    public final LargeRheostatDescriptor getDesc() {
        return this.desc;
    }

    public final double getNominalRs() {
        return this.nominalRs;
    }

    public final void setNominalRs(double d) {
        this.nominalRs = d;
    }

    @NotNull
    public final NbtElectricalLoad getALoad() {
        return this.aLoad;
    }

    @NotNull
    public final NbtElectricalLoad getBLoad() {
        return this.bLoad;
    }

    @NotNull
    public final Resistor getResistor() {
        return this.resistor;
    }

    @NotNull
    public final NbtElectricalGateInput getControl() {
        return this.control;
    }

    @NotNull
    public final ControlProcess getControlProcess() {
        return this.controlProcess;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    @NotNull
    public final ResistorHeatThermalLoad getHeater() {
        return this.heater;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalWatchdog() {
        return this.thermalWatchdog;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull((Object)lrdu, "lrdu");
        if (Intrinsics.areEqual((Object)lrdu, (Object)LRDU.Down) ^ true) {
            return null;
        }
        Direction direction = side;
        return Intrinsics.areEqual((Object)direction, (Object)this.front.right()) ? (ElectricalLoad)this.aLoad : (Intrinsics.areEqual((Object)direction, (Object)this.front.left()) ? (ElectricalLoad)this.bLoad : (Intrinsics.areEqual((Object)direction, (Object)this.front) ? (ElectricalLoad)this.control : (ElectricalLoad)null));
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull((Object)lrdu, "lrdu");
        if (Intrinsics.areEqual((Object)lrdu, (Object)LRDU.Down) ^ true) {
            return null;
        }
        Direction direction = side;
        return Intrinsics.areEqual((Object)direction, (Object)this.front.back()) ? (ThermalLoad)this.thermalLoad : (ThermalLoad)null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull((Object)lrdu, "lrdu");
        if (Intrinsics.areEqual((Object)lrdu, (Object)LRDU.Down) ^ true) {
            return 0;
        }
        Direction direction = side;
        return Intrinsics.areEqual((Object)direction, (Object)this.front) ? 4 : (Intrinsics.areEqual((Object)direction, (Object)this.front.back()) ? 2 : 1);
    }

    public final void setupPhysical() {
        this.nominalRs = this.desc.getRsValue((IInventory)this.inventory);
        this.controlProcess.process(0.0);
    }

    @Override
    public void inventoryChange(@Nullable IInventory inventory) {
        super.inventoryChange(inventory);
        this.setupPhysical();
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        double u = -Math.abs(this.aLoad.getU() - this.bLoad.getU());
        double i = Math.abs(this.resistor.getI());
        return Utils.plotOhm(Utils.plotUIP(u, i), this.resistor.getR()) + Utils.plotPercent("C", this.control.getNormalized());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        return Utils.plotCelsius("T: ", this.thermalLoad.Tc) + Utils.plotPower("P: ", this.thermalLoad.getPower());
    }

    @Override
    public void initialize() {
        this.desc.getDissipator().applyTo(this.thermalLoad);
        this.aLoad.setRs(1.0E-9);
        this.bLoad.setRs(1.0E-9);
        this.setupPhysical();
        this.connect();
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat((float)this.thermalLoad.Tc);
        stream.writeFloat((float)this.control.getNormalized());
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean onBlockActivated(@Nullable EntityPlayer entityPlayer, @Nullable Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    @NotNull
    public ResistorContainer newContainer(@Nullable Direction side, @Nullable EntityPlayer player) {
        return new ResistorContainer(player, (IInventory)this.inventory);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map<String, String> info = MapsKt.mutableMapOf(new Pair[0]);
        String string = Utils.plotValue(this.resistor.getR(), "\u03a9");
        Intrinsics.checkExpressionValueIsNotNull(string, "Utils.plotValue(resistor.r, \"\\u03A9\")");
        info.put("Resistance", string);
        return info;
    }

    /*
     * WARNING - void declaration
     */
    public LargeRheostatElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Resistor resistor;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(desc_, "desc_");
        super(node, desc_);
        TransparentNodeDescriptor transparentNodeDescriptor = desc_;
        if (transparentNodeDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type mods.eln.transparentnode.LargeRheostatDescriptor");
        }
        this.desc = (LargeRheostatDescriptor)transparentNodeDescriptor;
        this.nominalRs = 1.0;
        this.inventory = new TransparentNodeElementInventory(2, 64, this);
        this.aLoad = new NbtElectricalLoad("aLoad");
        this.bLoad = new NbtElectricalLoad("bLoad");
        Resistor resistor2 = new Resistor(this.aLoad, this.bLoad);
        LargeRheostatElement largeRheostatElement = this;
        Resistor resistor3 = resistor2;
        $receiver.setR(this.nominalRs);
        largeRheostatElement.resistor = resistor = resistor2;
        this.control = new NbtElectricalGateInput("control");
        this.controlProcess = new ControlProcess();
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        this.heater = new ResistorHeatThermalLoad(this.resistor, this.thermalLoad);
        this.thermalWatchdog = new ThermalLoadWatchDog();
        this.grounded = false;
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.resistor);
        this.electricalLoadList.add(this.control);
        this.slowProcessList.add(this.controlProcess);
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalFastProcessList.add(this.heater);
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setTMax(this.desc.getDissipator().warmLimit).set(new WorldExplosion(this).machineExplosion());
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u000f"}, d2={"Lmods/eln/transparentnode/LargeRheostatElement$ControlProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/transparentnode/LargeRheostatElement;)V", "lastC", "", "getLastC", "()D", "setLastC", "(D)V", "lastH", "getLastH", "setLastH", "process", "", "time", "ElectricalAge-release_main"})
    public final class ControlProcess
    implements IProcess {
        private double lastC = -1000.0;
        private double lastH = -1000.0;

        public final double getLastC() {
            return this.lastC;
        }

        public final void setLastC(double d) {
            this.lastC = d;
        }

        public final double getLastH() {
            return this.lastH;
        }

        public final void setLastH(double d) {
            this.lastH = d;
        }

        @Override
        public void process(double time) {
            double desiredRs = (LargeRheostatElement.this.getControl().getNormalized() + 0.01) / 1.01 * LargeRheostatElement.this.getNominalRs();
            if (desiredRs > this.lastC * 1.01 || desiredRs < this.lastC * 0.99) {
                LargeRheostatElement.this.getResistor().setR(desiredRs);
                this.lastC = desiredRs;
                LargeRheostatElement.this.needPublish();
            }
            if (LargeRheostatElement.this.getThermalLoad().Tc > this.lastH * 1.05 || LargeRheostatElement.this.getThermalLoad().Tc < this.lastH * 0.95) {
                this.lastH = LargeRheostatElement.this.getThermalLoad().Tc;
                LargeRheostatElement.this.needPublish();
            }
        }
    }
}

