/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.misc.BlackBodyColor;
import mods.eln.misc.Direction;
import mods.eln.misc.HSLColorKt;
import mods.eln.misc.SlewLimiter;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.transparentnode.LargeRheostatDescriptor;
import mods.eln.transparentnode.LargeRheostatGUI;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u0014\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lmods/eln/transparentnode/LargeRheostatRender;", "Lmods/eln/node/transparent/TransparentNodeElementRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "baseColor", "Lmods/eln/misc/BlackBodyColor;", "getBaseColor", "()Lmods/eln/misc/BlackBodyColor;", "color", "getColor", "setColor", "(Lmods/eln/misc/BlackBodyColor;)V", "Lmods/eln/transparentnode/LargeRheostatDescriptor;", "getDesc", "()Lmods/eln/transparentnode/LargeRheostatDescriptor;", "inventory", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInventory", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "positionAnimator", "Lmods/eln/misc/SlewLimiter;", "getPositionAnimator", "()Lmods/eln/misc/SlewLimiter;", "draw", "", "Lnet/minecraft/inventory/IInventory;", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "side", "Lmods/eln/misc/Direction;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "refresh", "deltaT", "", "ElectricalAge-release_main"})
public final class LargeRheostatRender
extends TransparentNodeElementRender {
    @NotNull
    private final LargeRheostatDescriptor desc;
    @NotNull
    private final TransparentNodeElementInventory inventory;
    @NotNull
    private final BlackBodyColor baseColor;
    @NotNull
    private BlackBodyColor color;
    @NotNull
    private final SlewLimiter positionAnimator;

    @NotNull
    public final LargeRheostatDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    @Override
    @NotNull
    public IInventory getInventory() {
        return (IInventory)this.inventory;
    }

    @NotNull
    public final BlackBodyColor getBaseColor() {
        return this.baseColor;
    }

    @NotNull
    public final BlackBodyColor getColor() {
        return this.color;
    }

    public final void setColor(@NotNull BlackBodyColor blackBodyColor) {
        Intrinsics.checkParameterIsNotNull(blackBodyColor, "<set-?>");
        this.color = blackBodyColor;
    }

    @NotNull
    public final SlewLimiter getPositionAnimator() {
        return this.positionAnimator;
    }

    @Override
    public void draw() {
        this.front.glRotateZnRef();
        GL11.glColor3f((float)this.color.getRed(), (float)this.color.getGreen(), (float)this.color.getBlue());
        this.desc.draw(this.positionAnimator.getPosition());
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.positionAnimator.step(deltaT);
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        super.networkUnserialize(stream);
        float temp = stream.readFloat() + (float)273;
        BlackBodyColor c = HSLColorKt.BlackBodyTemperature(temp);
        float p = HSLColorKt.BlackBodyPower(temp);
        BlackBodyColor bbc = c.times(p / (float)this.desc.getDissipator().nominalP);
        this.color = bbc.plus(this.baseColor).normalize();
        if (this.positionAnimator.getTarget() == -1.0f) {
            this.positionAnimator.setTarget(stream.readFloat());
            this.positionAnimator.setPosition(this.positionAnimator.getTarget());
        } else {
            this.positionAnimator.setTarget(stream.readFloat());
        }
    }

    @Override
    @NotNull
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull(player, "player");
        return (GuiScreen)new LargeRheostatGUI(player, (IInventory)this.inventory, this);
    }

    public LargeRheostatRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        super(entity, desc);
        TransparentNodeDescriptor transparentNodeDescriptor = desc;
        if (transparentNodeDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type mods.eln.transparentnode.LargeRheostatDescriptor");
        }
        this.desc = (LargeRheostatDescriptor)transparentNodeDescriptor;
        this.inventory = new TransparentNodeElementInventory(1, 64, this);
        this.baseColor = new BlackBodyColor(1.0f, 1.0f, 1.0f);
        this.color = HSLColorKt.BlackBodyTemperature(0.0f);
        this.positionAnimator = new SlewLimiter(0.3f);
        this.positionAnimator.setTarget(-1.0f);
    }
}

