/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sound.SoundCommand;
import mods.eln.transparentnode.autominer.AutoMinerElement;
import mods.eln.transparentnode.autominer.AutoMinerRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class AutoMinerDescriptor
extends TransparentNodeDescriptor {
    Coordonate[] powerCoord;
    Coordonate lightCoord;
    Coordonate miningCoord;
    public Obj3D obj;
    public Obj3D.Obj3DPart core;
    public Obj3D.Obj3DPart gui;
    public Obj3D.Obj3DPart lampSocket;
    public Obj3D.Obj3DPart lampOff;
    public Obj3D.Obj3DPart lampOn;
    public Obj3D.Obj3DPart head;
    public Obj3D.Obj3DPart pipe;
    public Obj3D.Obj3DPart buttonFixed;
    public Obj3D.Obj3DPart[] buttons;
    public Obj3D.Obj3DPart[] ledsA;
    public Obj3D.Obj3DPart[] ledsP;
    float[] buttonsStateDefault;
    boolean[] ledsAStateDefault;
    boolean[] ledsPStateDefault;
    int buttonsCount = 5;
    int ledsACount = 11;
    int ledsPCount = 8;
    int deltaX;
    int deltaY;
    int deltaZ;
    ElectricalCableDescriptor cable;
    SoundCommand runningSound;
    double nominalVoltage;
    double pipeOperationTime;
    double pipeOperationEnergy;
    double pipeOperationPower;
    double pipeOperationRp;

    public AutoMinerDescriptor(String name, Obj3D obj, Coordonate[] powerCoord, Coordonate lightCoord, Coordonate miningCoord, int deltaX, int deltaY, int deltaZ, ElectricalCableDescriptor cable, double pipeOperationTime, double pipeOperationEnergy) {
        super(name, AutoMinerElement.class, AutoMinerRender.class);
        int idx;
        this.nominalVoltage = cable.electricalNominalVoltage;
        this.pipeOperationTime = pipeOperationTime;
        this.pipeOperationEnergy = pipeOperationEnergy;
        this.pipeOperationPower = pipeOperationEnergy / pipeOperationTime;
        this.pipeOperationRp = this.nominalVoltage * this.nominalVoltage / this.pipeOperationPower;
        this.cable = cable;
        this.powerCoord = powerCoord;
        this.lightCoord = lightCoord;
        this.miningCoord = miningCoord;
        this.obj = obj;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.deltaZ = deltaZ;
        this.core = obj.getPart("AutominerCore");
        this.gui = obj.getPart("AutominerGUI");
        this.lampSocket = obj.getPart("LampSocket");
        this.lampOff = obj.getPart("LampOff");
        this.lampOn = obj.getPart("LampOn");
        this.head = obj.getPart("MinerHead");
        this.pipe = obj.getPart("MinerPipe");
        this.buttonFixed = obj.getPart("ButtonsFixed");
        this.buttons = new Obj3D.Obj3DPart[this.buttonsCount];
        this.buttonsStateDefault = new float[this.buttonsCount];
        for (idx = 0; idx < this.buttonsCount; ++idx) {
            this.buttons[idx] = obj.getPart("Button" + idx);
            this.buttonsStateDefault[idx] = (float)Math.random();
        }
        this.ledsA = new Obj3D.Obj3DPart[this.ledsACount];
        this.ledsAStateDefault = new boolean[this.ledsACount];
        for (idx = 0; idx < this.ledsACount; ++idx) {
            this.ledsA[idx] = obj.getPart("ledA" + idx);
            this.ledsAStateDefault[idx] = Math.random() > 0.5;
        }
        this.ledsP = new Obj3D.Obj3DPart[this.ledsPCount];
        this.ledsPStateDefault = new boolean[this.ledsPCount];
        for (idx = 0; idx < this.ledsPCount; ++idx) {
            this.ledsP[idx] = obj.getPart("ledP" + idx);
            this.ledsPStateDefault[idx] = Math.random() > 0.5;
        }
        this.runningSound = new SoundCommand("eln:autominer", 2.13);
        this.voltageLevelColor = VoltageLevelColor.HighVoltage;
    }

    public void applyTo(ElectricalLoad load) {
        this.cable.applyTo(load);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addMachine(this.newItemStack());
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    @Override
    public boolean mustHaveFloor() {
        return false;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Excavates on a small radius.\nExtracts ore on a bigger radius:\n10 blocks radius after 10 blocks depth.", new Object[0]).split("\n"));
        list.add(I18N.tr("Nominal voltage: %1$V", Utils.plotValue(this.nominalVoltage)));
    }

    void draw(boolean lampState, float[] buttonsState, boolean[] ledsAState, boolean[] ledsPState) {
        int idx;
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
        for (idx = 0; idx < this.buttonsCount; ++idx) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)((1.0f - buttonsState[idx]) * 0.01f), (float)0.0f);
            if (this.buttons[idx] != null) {
                this.buttons[idx].draw();
            }
            GL11.glPopMatrix();
        }
        UtilsClient.disableLight();
        for (idx = 0; idx < this.ledsACount; ++idx) {
            GL11.glColor3f((float)0.0f, (float)(ledsAState[idx] ? 0.0f : 1.0f), (float)0.0f);
            if (this.ledsA[idx] == null) continue;
            this.ledsA[idx].draw();
        }
        for (idx = 0; idx < this.ledsPCount; ++idx) {
            GL11.glColor3f((float)0.0f, (float)(ledsPState[idx] ? 0.0f : 1.0f), (float)0.0f);
            if (this.ledsP[idx] == null) continue;
            this.ledsP[idx].draw();
        }
        UtilsClient.enableLight();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        UtilsClient.disableCulling();
        this.core.draw();
        this.gui.draw();
        this.buttonFixed.draw();
        this.lampSocket.draw();
        if (lampState) {
            this.lampOff.draw();
        } else {
            this.lampOn.draw();
        }
        UtilsClient.enableCulling();
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glScalef((float)0.18f, (float)0.18f, (float)0.18f);
            this.draw(false, this.buttonsStateDefault, this.ledsAStateDefault, this.ledsPStateDefault);
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    public Coordonate[] getPowerCoordonate(World w) {
        Coordonate[] temp = new Coordonate[this.powerCoord.length];
        for (int idx = 0; idx < temp.length; ++idx) {
            temp[idx] = new Coordonate(this.powerCoord[idx]);
            temp[idx].setDimention(w.field_73011_w.field_76574_g);
        }
        return temp;
    }

    @Override
    public int getSpawnDeltaX() {
        return this.deltaX;
    }

    @Override
    public int getSpawnDeltaY() {
        return this.deltaY;
    }

    @Override
    public int getSpawnDeltaZ() {
        return this.deltaZ;
    }
}

