/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.autominer.AutoMinerContainer;
import mods.eln.transparentnode.autominer.AutoMinerDescriptor;
import mods.eln.transparentnode.autominer.AutoMinerPowerNode;
import mods.eln.transparentnode.autominer.AutoMinerSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class AutoMinerElement
extends TransparentNodeElement {
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(3, 64, this);
    NbtElectricalLoad inPowerLoad = new NbtElectricalLoad("inPowerLoad");
    AutoMinerSlowProcess slowProcess = new AutoMinerSlowProcess(this);
    Resistor powerResistor = new Resistor(this.inPowerLoad, null);
    AutoMinerDescriptor descriptor;
    Coordonate lightCoordonate;
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();
    ArrayList<AutoMinerPowerNode> powerNodeList = new ArrayList();
    boolean powerOk = false;
    public static final byte pushLogId = 1;
    public static final byte toggleSilkTouch = 2;

    public AutoMinerElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (AutoMinerDescriptor)descriptor;
        this.electricalLoadList.add(this.inPowerLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.set(this.inPowerLoad).setUNominal(this.descriptor.nominalVoltage).set(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.inPowerLoad;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        return 1;
    }

    @Override
    public String multiMeterString(Direction side) {
        return Utils.plotUIP(this.inPowerLoad.getU(), this.inPowerLoad.getCurrent());
    }

    @Override
    public String thermoMeterString(Direction side) {
        return "";
    }

    @Override
    public void initialize() {
        this.lightCoordonate = new Coordonate(this.descriptor.lightCoord);
        this.lightCoordonate.applyTransformation(this.front, this.node.coordonate);
        int idx = 0;
        for (Coordonate c : this.descriptor.getPowerCoordonate(this.node.coordonate.world())) {
            AutoMinerPowerNode n = new AutoMinerPowerNode();
            n.setElement(this);
            c.applyTransformation(this.front, this.node.coordonate);
            Direction dir = idx != 0 ? this.front.left() : this.front.right();
            n.onBlockPlacedBy(c, dir, null, null);
            this.powerNodeList.add(n);
            ++idx;
        }
        this.descriptor.applyTo(this.inPowerLoad);
        this.connect();
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        this.slowProcess.onBreakElement();
        for (AutoMinerPowerNode n : this.powerNodeList) {
            n.onBreakBlock();
        }
        this.powerNodeList.clear();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new AutoMinerContainer(this.node, player, (IInventory)this.inventory);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void ghostDestroyed(int UUID) {
        if (UUID == this.descriptor.getGhostGroupUuid()) {
            super.ghostDestroyed(UUID);
        }
        this.slowProcess.ghostDestroyed(UUID);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeShort(this.slowProcess.pipeLength);
            stream.writeByte(this.slowProcess.job.ordinal());
            stream.writeBoolean(this.powerOk);
            stream.writeBoolean(this.slowProcess.silkTouch);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPowerOk(boolean b) {
        this.powerOk = b;
        if (this.powerOk != this.powerOk) {
            this.needPublish();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powerOk", this.powerOk);
        nbt.func_74757_a("silkTouch", this.slowProcess.silkTouch);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerOk = nbt.func_74767_n("powerOk");
        this.slowProcess.silkTouch = nbt.func_74767_n("silkTouch");
    }

    void pushLog(String log) {
        this.sendStringToAllClient((byte)1, log);
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        switch (packetType) {
            case 2: {
                this.slowProcess.toggleSilkTouch();
                this.needPublish();
                break;
            }
            default: {
                return packetType;
            }
        }
        return -128;
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Silk Touch", this.slowProcess.silkTouch ? "Yes" : "No");
        info.put("Depth", Utils.plotValue(this.slowProcess.pipeLength, "m "));
        return info;
    }
}

