/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.item.ElectricalDrillDescriptor;
import mods.eln.item.MiningPipeDescriptor;
import mods.eln.item.electricalitem.PortableOreScannerItem;
import mods.eln.misc.Coordonate;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.ore.OreBlock;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.lampsocket.LightBlockEntity;
import mods.eln.sound.SoundCommand;
import mods.eln.sound.SoundLooper;
import mods.eln.transparentnode.autominer.AutoMinerElement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public class AutoMinerSlowProcess
implements IProcess,
INBTTReady {
    AutoMinerElement miner;
    SoundLooper looper;
    int pipeLength = 0;
    double energyCounter = 0.0;
    double energyTarget = 0.0;
    int workY;
    boolean oneJobDone = true;
    boolean silkTouch = false;
    jobType job = jobType.none;
    jobType oldJob = jobType.none;
    Coordonate jobCoord = new Coordonate();
    int blinkCounter = 0;
    double oreRand = Math.random();
    int drillCount = 1;

    public AutoMinerSlowProcess(AutoMinerElement autoMiner) {
        this.miner = autoMiner;
        this.looper = new SoundLooper(autoMiner){

            @Override
            public SoundCommand mustStart() {
                if (AutoMinerSlowProcess.this.miner.powerOk && (AutoMinerSlowProcess.this.job == jobType.ore || AutoMinerSlowProcess.this.job == jobType.pipeAdd || AutoMinerSlowProcess.this.job == jobType.pipeRemove)) {
                    return AutoMinerSlowProcess.this.miner.descriptor.runningSound.copy();
                }
                return null;
            }
        };
    }

    void toggleSilkTouch() {
        this.silkTouch = !this.silkTouch;
    }

    boolean isReadyToDrill() {
        ElectricalDrillDescriptor drill = (ElectricalDrillDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.inventory.func_70301_a(0));
        if (drill == null) {
            return false;
        }
        return this.isStorageReady();
    }

    boolean isStorageReady() {
        IInventory i = this.getDropInventory();
        if (i == null) {
            return false;
        }
        for (int idx = 0; idx < i.func_70302_i_(); ++idx) {
            if (i.func_70301_a(idx) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(double time) {
        ElectricalDrillDescriptor drill = (ElectricalDrillDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.inventory.func_70301_a(0));
        MiningPipeDescriptor pipe = (MiningPipeDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.inventory.func_70301_a(2));
        if (++this.blinkCounter >= 9) {
            this.blinkCounter = 0;
            if ((this.miner.inPowerLoad.getU() / this.miner.descriptor.nominalVoltage - 0.5) * 3.0 > Math.random()) {
                this.miner.setPowerOk(true);
                LightBlockEntity.addLight(this.miner.lightCoordonate, 12, 11);
            } else {
                this.miner.setPowerOk(false);
            }
        }
        this.energyCounter += this.miner.powerResistor.getP() * time;
        if (this.job != jobType.none && this.job != jobType.full && this.job != jobType.chestFull && this.job != jobType.done) {
            if (this.energyCounter >= this.energyTarget || this.job == jobType.ore && !this.isReadyToDrill() || !this.miner.powerOk) {
                this.setupJob();
            }
            if (this.energyCounter >= this.energyTarget) {
                this.oneJobDone = true;
                switch (this.job) {
                    case ore: {
                        ++this.drillCount;
                        Block block = this.jobCoord.world().func_147439_a(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        int meta = this.jobCoord.world().func_72805_g(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        if (this.silkTouch) {
                            this.drop(new ItemStack(block, 1, meta));
                        } else {
                            ArrayList drop = block.getDrops(this.jobCoord.world(), this.jobCoord.x, this.jobCoord.y, this.jobCoord.z, meta, 0);
                            for (ItemStack stack : drop) {
                                this.drop(stack);
                            }
                        }
                        int xDist = this.jobCoord.x - this.miner.node.coordonate.x;
                        int zDist = this.jobCoord.z - this.miner.node.coordonate.z;
                        if (xDist * xDist + zDist * zDist > 25) {
                            this.jobCoord.world().func_147449_b(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z, Blocks.field_150347_e);
                        } else {
                            this.jobCoord.world().func_147468_f(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        }
                        this.energyCounter -= this.energyTarget;
                        this.oreRand = Math.random();
                        this.setupJob();
                        break;
                    }
                    case pipeAdd: {
                        Eln.ghostManager.createGhost(this.jobCoord, this.miner.node.coordonate, this.jobCoord.y);
                        this.miner.inventory.func_70298_a(2, 1);
                        ++this.pipeLength;
                        this.miner.needPublish();
                        this.energyCounter -= this.energyTarget;
                        this.setupJob();
                        break;
                    }
                    case pipeRemove: {
                        Eln.ghostManager.removeGhostAndBlock(this.jobCoord);
                        if (this.miner.inventory.func_70301_a(2) == null) {
                            this.miner.inventory.func_70299_a(2, Eln.miningPipeDescriptor.newItemStack(1));
                        } else {
                            this.miner.inventory.func_70298_a(2, -1);
                        }
                        --this.pipeLength;
                        this.miner.needPublish();
                        this.energyCounter -= this.energyTarget;
                        this.setupJob();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            this.setupJob();
        }
        switch (this.job) {
            default: {
                this.miner.powerResistor.highImpedance();
                break;
            }
            case ore: {
                if (drill == null) {
                    this.miner.powerResistor.highImpedance();
                    break;
                }
                double p = drill.nominalPower;
                if (this.silkTouch) {
                    p *= 3.0;
                }
                this.miner.powerResistor.setR(Math.pow(this.miner.descriptor.nominalVoltage, 2.0) / p);
                break;
            }
            case pipeAdd: {
                this.miner.powerResistor.setR(this.miner.descriptor.pipeOperationRp);
                break;
            }
            case pipeRemove: {
                this.miner.powerResistor.setR(this.miner.descriptor.pipeOperationRp);
            }
        }
        if (this.oldJob != this.job) {
            this.miner.needPublish();
        }
        if (this.oneJobDone || this.oldJob != this.job) {
            switch (this.job) {
                case chestFull: {
                    this.miner.pushLog("* Storage full!");
                    break;
                }
                case done: {
                    this.miner.pushLog("- SLEEP");
                    break;
                }
                case full: {
                    this.miner.pushLog("* Pipe stack full!");
                    break;
                }
                case none: {
                    this.miner.pushLog("* Waiting opcode.");
                    break;
                }
                case ore: {
                    this.miner.pushLog("- DRILL #" + this.drillCount);
                    break;
                }
                case pipeAdd: {
                    this.miner.pushLog("- ADD PIPE #" + (this.pipeLength + 1));
                    break;
                }
                case pipeRemove: {
                    this.miner.pushLog("- REMOVE PIPE #" + this.pipeLength);
                    break;
                }
            }
        }
        this.oneJobDone = false;
        this.oldJob = this.job;
        this.looper.process(time);
    }

    IInventory getDropInventory() {
        TileEntityChest chestEntity = null;
        Coordonate c = new Coordonate(2, -1, 0, this.miner.world());
        c.applyTransformation(this.miner.front, this.miner.coordonate());
        if (c.getTileEntity() instanceof TileEntityChest) {
            chestEntity = (TileEntityChest)c.getTileEntity();
        }
        c = new Coordonate(1, -1, 0, this.miner.world());
        c.applyTransformation(this.miner.front, this.miner.coordonate());
        if (c.getTileEntity() instanceof TileEntityChest) {
            chestEntity = (TileEntityChest)c.getTileEntity();
        }
        return chestEntity;
    }

    public void drop(ItemStack stack) {
        Utils.tryPutStackInInventory(stack, this.getDropInventory(), 0, 36);
    }

    boolean isMinable(Block block) {
        return block != Blocks.field_150350_a && block != Blocks.field_150358_i && block != Blocks.field_150355_j && block != Blocks.field_150356_k && block != Blocks.field_150353_l && block != Blocks.field_150343_Z && block != Blocks.field_150357_h;
    }

    void setupJob() {
        ElectricalDrillDescriptor drill = (ElectricalDrillDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.inventory.func_70301_a(0));
        MiningPipeDescriptor pipe = (MiningPipeDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.inventory.func_70301_a(2));
        int scannerRadius = Eln.instance.autominerRange;
        double scannerEnergy = 0.0;
        this.jobCoord.dimention = this.miner.node.coordonate.dimention;
        this.jobCoord.x = this.miner.node.coordonate.x;
        this.jobCoord.y = this.miner.node.coordonate.y - this.pipeLength;
        this.jobCoord.z = this.miner.node.coordonate.z;
        boolean jobFind = false;
        if (!this.miner.node.coordonate.getBlockExist()) {
            this.setJob(jobType.none);
        } else if (!this.miner.powerOk) {
            this.setJob(jobType.none);
        } else if (drill == null) {
            if (this.jobCoord.y != this.miner.node.coordonate.y) {
                ItemStack pipeStack = this.miner.inventory.func_70301_a(2);
                if (pipeStack == null || pipeStack.field_77994_a != pipeStack.func_77976_d() && pipeStack.field_77994_a != this.miner.inventory.func_70297_j_()) {
                    jobFind = true;
                    this.setJob(jobType.pipeRemove);
                } else {
                    jobFind = true;
                    this.setJob(jobType.full);
                }
            }
        } else if (!this.isStorageReady()) {
            this.setJob(jobType.chestFull);
            jobFind = true;
        } else if (pipe != null) {
            if (this.jobCoord.y < this.miner.node.coordonate.y - 2) {
                int depth = this.miner.node.coordonate.y - this.jobCoord.y;
                double miningRay = (double)(depth / 10) + 0.1;
                miningRay = Math.min(miningRay, 2.0);
                if (depth < scannerRadius) {
                    scannerRadius = depth + 1;
                }
                miningRay = Math.min(miningRay, (double)(scannerRadius - 2));
                this.jobCoord.z = this.miner.node.coordonate.z - scannerRadius;
                while (this.jobCoord.z <= this.miner.node.coordonate.z + scannerRadius) {
                    this.jobCoord.x = this.miner.node.coordonate.x - scannerRadius;
                    while (this.jobCoord.x <= this.miner.node.coordonate.x + scannerRadius) {
                        double dx = this.jobCoord.x - this.miner.node.coordonate.x;
                        double dy = 0.0;
                        double dz = this.jobCoord.z - this.miner.node.coordonate.z;
                        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        Block block = this.jobCoord.world().func_147439_a(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        if (this.checkIsOre(this.jobCoord) || distance > 0.1 && distance < miningRay && this.isMinable(block)) {
                            jobFind = true;
                            this.setJob(jobType.ore);
                            break;
                        }
                        ++this.jobCoord.x;
                    }
                    if (jobFind) break;
                    ++this.jobCoord.z;
                }
            }
            if (!jobFind) {
                if (this.jobCoord.y < 3) {
                    jobFind = true;
                    this.setJob(jobType.done);
                } else {
                    this.jobCoord.x = this.miner.node.coordonate.x;
                    --this.jobCoord.y;
                    this.jobCoord.z = this.miner.node.coordonate.z;
                    Block block = this.jobCoord.world().func_147439_a(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                    if (block != Blocks.field_150350_a && block != Blocks.field_150358_i && block != Blocks.field_150355_j && block != Blocks.field_150356_k && block != Blocks.field_150353_l) {
                        if (block != Blocks.field_150343_Z && block != Blocks.field_150357_h) {
                            jobFind = true;
                            this.setJob(jobType.ore);
                        } else {
                            jobFind = true;
                            this.setJob(jobType.done);
                        }
                    } else {
                        jobFind = true;
                        this.setJob(jobType.pipeAdd);
                    }
                }
            }
        }
        if (!jobFind) {
            this.setJob(jobType.none);
        }
        switch (this.job) {
            case ore: {
                this.energyTarget = drill.OperationEnergy + scannerEnergy;
                if (!this.silkTouch) break;
                this.energyTarget *= 6.0;
                break;
            }
            case pipeAdd: {
                this.energyTarget = this.miner.descriptor.pipeOperationEnergy;
                break;
            }
            case pipeRemove: {
                this.energyTarget = this.miner.descriptor.pipeOperationEnergy;
                break;
            }
            default: {
                this.energyTarget = 0.0;
            }
        }
    }

    void setJob(jobType job) {
        if (job != this.job) {
            this.miner.needPublish();
            this.energyCounter = 0.0;
        }
        this.job = job;
    }

    boolean checkIsOre(Coordonate coordonate) {
        Block block = coordonate.world().func_147439_a(coordonate.x, coordonate.y, coordonate.z);
        if (block instanceof BlockOre) {
            return true;
        }
        if (block instanceof OreBlock) {
            return true;
        }
        if (block instanceof BlockRedstoneOre) {
            return true;
        }
        return PortableOreScannerItem.RenderStorage.getBlockKeyFactor()[Block.func_149682_b((Block)block) + (coordonate.world().func_72805_g(coordonate.x, coordonate.y, coordonate.z) << 12)] != 0.0f;
    }

    public void onBreakElement() {
        this.destroyPipe(-1);
    }

    void destroyPipe(int jumpY) {
        this.dropPipe(jumpY);
        Eln.ghostManager.removeGhostAndBlockWithObserverAndNotUuid(this.miner.node.coordonate, this.miner.descriptor.getGhostGroupUuid());
        this.pipeLength = 0;
        this.miner.needPublish();
    }

    void dropPipe(int jumpY) {
        World world = this.miner.node.coordonate.world();
        Coordonate coord = new Coordonate(this.miner.node.coordonate);
        coord.y = this.miner.node.coordonate.y - 1;
        while (coord.y >= this.miner.node.coordonate.y - this.pipeLength) {
            Utils.dropItem(Eln.miningPipeDescriptor.newItemStack(1), coord);
            --coord.y;
        }
    }

    public void ghostDestroyed(int UUID) {
        this.destroyPipe(UUID);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.pipeLength = nbt.func_74762_e(str + "AMSPpipeLength");
        this.drillCount = nbt.func_74762_e(str + "AMSPdrillCount");
        if (this.drillCount == 0) {
            ++this.drillCount;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74768_a(str + "AMSPpipeLength", this.pipeLength);
        nbt.func_74768_a(str + "AMSPdrillCount", this.drillCount);
    }

    static enum jobType {
        none,
        done,
        full,
        chestFull,
        ore,
        pipeAdd,
        pipeRemove;

    }
}

