/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.BatteryProcess;
import mods.eln.sim.BatterySlowProcess;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.Simulator;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.battery.BatteryElement;
import mods.eln.transparentnode.battery.BatteryRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;

public class BatteryDescriptor
extends TransparentNodeDescriptor {
    public double electricalU;
    public double electricalDischargeRate;
    public double electricalStdP;
    public double electricalStdDischargeTime;
    public double electricalStdHalfLife;
    public double electricalStdEfficiency;
    public double electricalPMax;
    public double electricalStdEnergy;
    public double electricalStdI;
    public double thermalHeatTime;
    public double thermalWarmLimit;
    public double thermalCoolLimit;
    public double electricalQ;
    public double electricalRs;
    public double electricalRp;
    public double thermalC;
    public double thermalRp;
    public double thermalPMax;
    public double lifeNominalCurrent;
    public double lifeNominalLost;
    public double startCharge;
    public boolean isRechargable;
    String description = "todo battery";
    FunctionTable UfCharge;
    String modelName;
    Obj3D.Obj3DPart modelPart;
    public double IMax;
    public boolean lifeEnable;
    private ElectricalCableDescriptor cable;
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart plugPlus;
    Obj3D.Obj3DPart plusMinus;
    Obj3D.Obj3DPart battery;
    int renderType;
    private String renderSpec;
    public static final BatteryDescriptor[] list = new BatteryDescriptor[8];
    public double currentDropVoltage = 1000000.0;
    public double currentDropFactor = 0.0;

    public void draw(boolean plus, boolean minus2) {
        switch (this.renderType) {
            case 0: {
                if (this.modelPart == null) {
                    return;
                }
                this.modelPart.draw();
                break;
            }
            case 1: {
                if (this.main != null) {
                    this.main.draw();
                }
                if (this.plugPlus != null && plus) {
                    this.plugPlus.draw();
                }
                if (this.plusMinus != null && minus2) {
                    this.plusMinus.draw();
                }
                if (this.battery == null) break;
                this.battery.draw();
            }
        }
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    public BatteryDescriptor(String name, String modelName, ElectricalCableDescriptor cable, double startCharge, boolean isRechargable, boolean lifeEnable, FunctionTable UfCharge, double electricalU, double electricalPMax, double electricalDischargeRate, double electricalStdP, double electricalStdDischargeTime, double electricalStdEfficiency, double electricalStdHalfLife, double thermalHeatTime, double thermalWarmLimit, double thermalCoolLimit, String description) {
        super(name, BatteryElement.class, BatteryRender.class);
        this.electricalU = electricalU;
        this.electricalDischargeRate = electricalDischargeRate;
        this.electricalStdEfficiency = electricalStdEfficiency;
        this.electricalStdP = electricalStdP;
        this.electricalStdHalfLife = electricalStdHalfLife;
        this.electricalStdDischargeTime = electricalStdDischargeTime;
        this.startCharge = startCharge;
        this.isRechargable = isRechargable;
        this.lifeEnable = lifeEnable;
        this.cable = cable;
        this.thermalHeatTime = thermalHeatTime;
        this.thermalWarmLimit = thermalWarmLimit;
        this.thermalCoolLimit = thermalCoolLimit;
        this.electricalPMax = electricalPMax;
        this.UfCharge = UfCharge;
        this.description = description;
        this.electricalStdI = electricalStdP / electricalU;
        this.electricalStdEnergy = electricalStdDischargeTime * electricalStdP;
        this.electricalQ = electricalStdP * electricalStdDischargeTime / electricalU;
        this.electricalQ = 1.0;
        double energy = this.getEnergy(1.0, 1.0);
        this.electricalQ *= this.electricalStdEnergy / energy;
        this.electricalRs = electricalStdP * (1.0 - electricalStdEfficiency) / this.electricalStdI / this.electricalStdI / 2.0;
        this.electricalRp = Math.min(electricalU * electricalU / electricalStdP / electricalDischargeRate, 1.0E9);
        this.lifeNominalCurrent = electricalStdP / electricalU;
        this.lifeNominalLost = 0.5 / electricalStdHalfLife;
        this.thermalPMax = electricalPMax / electricalU * electricalPMax / electricalU * this.electricalRs * 2.0;
        this.thermalC = Math.pow(electricalPMax / electricalU, 2.0) * this.electricalRs * thermalHeatTime / thermalWarmLimit;
        this.thermalRp = thermalWarmLimit / this.thermalPMax;
        this.IMax = this.electricalStdI * 3.0;
        this.obj = Eln.obj.getObj(modelName);
        if (this.obj != null) {
            if (this.obj.getString("type").equals("A")) {
                this.renderType = 0;
            }
            if (this.obj.getString("type").equals("B")) {
                this.renderType = 1;
            }
            switch (this.renderType) {
                case 0: {
                    this.modelPart = this.obj.getPart("Battery");
                }
            }
        }
        this.voltageLevelColor = VoltageLevelColor.fromVoltage(electricalU);
        this.changeDefaultIcon("battery");
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    public void applyTo(Resistor resistor) {
        resistor.setR(this.electricalRp);
    }

    public void applyTo(BatteryProcess battery) {
        battery.uNominal = this.electricalU;
        battery.QNominal = this.electricalQ;
        battery.voltageFunction = this.UfCharge;
        battery.isRechargeable = this.isRechargable;
        if (battery.Q > 1.5 && battery.getU() > battery.uNominal / 4.0) {
            battery.Q /= this.electricalQ;
        }
    }

    public void applyTo(ElectricalLoad load, Simulator simulator) {
        load.setRs(this.electricalRs);
    }

    public void applyTo(ThermalLoad load) {
        load.Rp = this.thermalRp;
        load.C = this.thermalC;
    }

    public void applyTo(BatterySlowProcess process) {
        process.lifeNominalCurrent = this.lifeNominalCurrent;
        process.lifeNominalLost = this.lifeNominalLost;
    }

    public static BatteryDescriptor getDescriptorFrom(ItemStack itemStack) {
        return list[itemStack.func_77960_j() & 7];
    }

    @Override
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("charge", this.startCharge);
        nbt.func_74780_a("life", 1.0);
        return nbt;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Nominal voltage: %1$V", Utils.plotValue(this.electricalU)));
        list.add(I18N.tr("Nominal power: %1$W", Utils.plotValue(this.electricalStdP)));
        list.add(I18N.tr("Energy capacity: %1$J", Utils.plotValue(this.electricalStdDischargeTime * this.electricalStdP / 1000.0)));
        list.add(I18N.tr("Internal resistance: %1$\u2126", Utils.plotValue(this.electricalRs * 2.0)));
        list.add("");
        list.add(I18N.tr("Actual charge: %1$%", Utils.plotValue(this.getChargeInTag(itemStack) * 100.0)));
        if (this.lifeEnable) {
            list.add("Life : " + (int)(this.getLifeInTag(itemStack) * 100.0) + "%");
        }
    }

    @Override
    public String getName(ItemStack stack) {
        return super.getName(stack) + I18N.tr(" charged at %1$%", (int)(this.getChargeInTag(stack) * 100.0));
    }

    double getChargeInTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(this.getDefaultNBT());
        }
        return stack.func_77978_p().func_74769_h("charge");
    }

    double getLifeInTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(this.getDefaultNBT());
        }
        return stack.func_77978_p().func_74769_h("life");
    }

    public double getEnergy(double charge, double life) {
        int stepNbr = 50;
        double chargeStep = charge / (double)stepNbr;
        double chargeIntegrator = 0.0;
        double energy = 0.0;
        double QperStep = this.electricalQ * life * charge / (double)stepNbr;
        for (int step = 0; step < stepNbr; ++step) {
            double voltage = this.UfCharge.getValue(chargeIntegrator) * this.electricalU;
            energy += voltage * QperStep;
            chargeIntegrator += chargeStep;
        }
        return energy;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(true, true);
        }
    }

    @Override
    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.func_70027_ad()) {
            entityItem.field_70170_p.func_72876_a((Entity)entityItem, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 2.0f, true);
            entityItem.func_70066_B();
            entityItem.func_70106_y();
        }
        return false;
    }

    public void setRenderSpec(String renderSpec) {
        this.renderSpec = renderSpec;
        if (this.obj != null) {
            switch (this.renderType) {
                case 0: 
                case 1: {
                    this.main = this.obj.getPart("main");
                    this.plugPlus = this.obj.getPart("plugPlus");
                    this.plusMinus = this.obj.getPart("plugMinus");
                    this.battery = this.obj.getPart("battery_" + renderSpec);
                }
            }
        }
    }

    public void setCurrentDrop(double currentDropVoltage, double currentDropFactor) {
        this.currentDropFactor = currentDropFactor;
        this.currentDropVoltage = currentDropVoltage;
    }
}

