/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.NodeVoltageState;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.nbt.NbtBatteryProcess;
import mods.eln.sim.nbt.NbtBatterySlowProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import mods.eln.transparentnode.battery.BatteryContainer;
import mods.eln.transparentnode.battery.BatteryDescriptor;
import mods.eln.transparentnode.battery.BatteryInventoryProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class BatteryElement
extends TransparentNodeElement {
    public NbtElectricalLoad cutLoad = new NbtElectricalLoad("cutLoad");
    public NodeVoltageState positiveLoad = new NodeVoltageState("positiveLoad");
    public NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    public VoltageSource voltageSource = new VoltageSource("volSrc", this.positiveLoad, this.negativeLoad);
    public NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    public ElectricalLoadHeatThermalLoad negativeETProcess = new ElectricalLoadHeatThermalLoad(this.negativeLoad, this.thermalLoad);
    public ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();
    public NbtBatteryProcess batteryProcess = new NbtBatteryProcess(this.positiveLoad, this.negativeLoad, null, 0.0, this.voltageSource);
    public Resistor dischargeResistor = new Resistor(this.positiveLoad, this.negativeLoad);
    public ResistorSwitch cutSwitch = new ResistorSwitch("cutSwitch", this.cutLoad, this.positiveLoad);
    public BatteryInventoryProcess inventoryProcess = new BatteryInventoryProcess(this);
    double syncronizedPositiveUc;
    double syncronizedNegativeUc;
    double syncronizedCurrent;
    double syncronizedTc;
    NbtBatterySlowProcess batterySlowProcess = new NbtBatterySlowProcess(this.node, this.batteryProcess, this.thermalLoad);
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(2, 64, this);
    boolean fromNBT = false;
    public BatteryDescriptor descriptor;
    boolean fromItemStack = false;
    double fromItemStack_charge;
    double fromItemStack_life;

    public BatteryElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (BatteryDescriptor)descriptor;
        this.electricalLoadList.add(this.cutLoad);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(new Resistor(this.positiveLoad, null));
        this.electricalComponentList.add(new Resistor(this.negativeLoad, null));
        this.electricalComponentList.add(this.dischargeResistor);
        this.electricalComponentList.add(this.voltageSource);
        this.electricalComponentList.add(this.cutSwitch);
        this.thermalLoadList.add(this.thermalLoad);
        this.electricalProcessList.add(this.batteryProcess);
        this.thermalFastProcessList.add(this.negativeETProcess);
        this.slowProcessList.add(this.batterySlowProcess);
        this.slowProcessList.add(this.inventoryProcess);
        this.grounded = false;
        this.batteryProcess.setIMax(this.descriptor.IMax);
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setTMax(this.descriptor.thermalWarmLimit).set(new WorldExplosion(this).machineExplosion());
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public boolean hasOverVoltageProtection() {
        return this.inventory.func_70301_a(0) != null;
    }

    public boolean hasOverHeatingProtection() {
        return this.inventory.func_70301_a(1) != null;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.left()) {
            return this.cutLoad;
        }
        if (side == this.front.right() && !this.grounded) {
            return this.negativeLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.front.left()) {
            return 1;
        }
        if (side == this.front.right() && !this.grounded) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return Utils.plotVolt("Ubat:", this.batteryProcess.getU()) + Utils.plotAmpere("Current Output:", this.batteryProcess.getDischargeCurrent());
    }

    @Override
    public String thermoMeterString(Direction side) {
        return Utils.plotCelsius("Tbat:", this.thermalLoad.Tc);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            double U = this.batteryProcess.getU();
            stream.writeFloat((float)(U * this.batteryProcess.getDischargeCurrent()));
            stream.writeFloat((float)this.batteryProcess.getEnergy());
            stream.writeShort((short)(this.batteryProcess.life * 1000.0));
            this.node.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.initPhysicalValue();
        this.connect();
    }

    public void initPhysicalValue() {
        this.descriptor.applyTo(this.batteryProcess);
        this.descriptor.applyTo(this.thermalLoad);
        this.descriptor.applyTo(this.dischargeResistor);
        this.descriptor.applyTo(this.batterySlowProcess);
        this.cutSwitch.setR(this.descriptor.electricalRs / 2.0);
        this.cutLoad.setRs(this.descriptor.electricalRs / 2.0);
        this.negativeLoad.setRs(this.descriptor.electricalRs);
        if (this.fromItemStack) {
            this.batteryProcess.life = this.fromItemStack_life;
            this.batteryProcess.setCharge(this.fromItemStack_charge);
            this.fromItemStack = false;
        }
    }

    @Override
    public void inventoryChange(IInventory inventory) {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.fromNBT = true;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new BatteryContainer(this.node, player, (IInventory)this.inventory);
    }

    @Override
    public void onGroundedChangedByClient() {
        super.onGroundedChangedByClient();
        this.disconnect();
        this.initPhysicalValue();
        this.reconnect();
    }

    @Override
    public void readItemStackNBT(NBTTagCompound nbt) {
        super.readItemStackNBT(nbt);
        if (nbt == null) {
            nbt = this.descriptor.getDefaultNBT();
        }
        this.fromItemStack_charge = nbt.func_74769_h("charge");
        this.fromItemStack_life = nbt.func_74769_h("life");
        this.fromItemStack = true;
    }

    @Override
    public NBTTagCompound getItemStackNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("charge", this.batteryProcess.getCharge());
        nbt.func_74780_a("life", this.batteryProcess.life);
        return nbt;
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> wailaList = new HashMap<String, String>();
        DecimalFormat df = new DecimalFormat("#.##");
        String current = "";
        NbtBatteryProcess p = this.batteryProcess;
        String charge = df.format(p.getCharge() * 100.0) + "%";
        String energy = df.format(p.getEnergy() / 1000.0) + "kJ";
        String life = df.format(p.life * 100.0) + "%";
        String voltage = df.format(p.getU()) + "v";
        current = df.format(p.getDischargeCurrent()) + "a";
        wailaList.put("Charge", charge);
        wailaList.put("Energy", energy);
        wailaList.put("Life", life);
        if (Eln.wailaEasyMode) {
            wailaList.put("Voltage", voltage);
            wailaList.put("Current", current);
        }
        return wailaList;
    }
}

