/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import mods.eln.gui.GuiButtonEln;
import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiVerticalProgressBar;
import mods.eln.gui.HelperStdContainer;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.transparentnode.battery.BatteryContainer;
import mods.eln.transparentnode.battery.BatteryRender;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class BatteryGuiDraw
extends GuiContainerEln {
    private TransparentNodeElementInventory inventory;
    BatteryRender render;
    GuiButtonEln buttonGrounded;
    GuiVerticalProgressBar energyBar;

    public BatteryGuiDraw(EntityPlayer player, IInventory inventory, BatteryRender render) {
        super(new BatteryContainer(null, player, inventory));
        this.inventory = (TransparentNodeElementInventory)inventory;
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonGrounded = this.newGuiButton(8, 45, 100, "");
        this.buttonGrounded.field_146125_m = false;
        this.energyBar = this.newGuiVerticalProgressBar(151, 8, 16, 69);
        this.energyBar.setColor(0.2f, 0.5f, 0.8f);
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (this.buttonGrounded == object) {
            this.render.clientSetGrounded(!this.render.grounded);
        }
    }

    @Override
    protected void func_146979_b(int param1, int param2) {
        super.func_146979_b(param1, param2);
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        this.buttonGrounded.field_146126_j = I18N.tr("Grounded: " + this.render.grounded, new Object[0]);
        this.energyBar.setValue((float)((double)this.render.energy / (this.render.descriptor.electricalStdEnergy * (double)this.render.life)));
        this.energyBar.setComment(0, I18N.tr("Energy: %1$", Utils.plotPercent("", this.energyBar.getValue()).replace(" ", "")));
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        String str1;
        super.postDraw(f, x, y);
        String str2 = "";
        double p = this.render.power;
        double energyMiss = this.render.descriptor.electricalStdEnergy * (double)this.render.life - (double)this.render.energy;
        if (Math.abs(p) < 5.0) {
            str1 = I18N.tr("No charge", new Object[0]);
        } else if (p > 0.0) {
            str1 = I18N.tr("Discharge", new Object[0]);
            str2 = Utils.plotTime("", (double)this.render.energy / p);
        } else if (energyMiss > 0.0) {
            str1 = I18N.tr("Charge", new Object[0]);
            str2 = Utils.plotTime("", -energyMiss / p);
        } else {
            str1 = I18N.tr("Charged", new Object[0]);
        }
        int xDelta = 70;
        if (this.render.descriptor.lifeEnable) {
            this.drawString(8, 8, I18N.tr("Life:", new Object[0]));
            this.drawString(xDelta, 8, Utils.plotPercent("", this.render.life));
        }
        this.drawString(8, 17, I18N.tr("Energy:", new Object[0]));
        this.drawString(xDelta, 17, Utils.plotValue(this.render.energy, "J/") + Utils.plotValue(this.render.descriptor.electricalStdEnergy * (double)this.render.life, "J"));
        if (this.render.power >= 0.0f) {
            this.drawString(8, 26, I18N.tr("Power out:", new Object[0]));
        } else {
            this.drawString(8, 26, I18N.tr("Power in:", new Object[0]));
        }
        this.drawString(xDelta, 26, Utils.plotValue(Math.abs(this.render.power), "W/") + Utils.plotValue(this.render.descriptor.electricalStdP, "W"));
        this.drawString(8, 35, str1);
        this.drawString(xDelta, 35, str2);
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new HelperStdContainer((GuiScreen)this);
    }
}

