/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import mods.eln.sim.IProcess;
import mods.eln.transparentnode.battery.BatteryElement;

public class BatteryInventoryProcess
implements IProcess {
    BatteryElement battery;
    boolean thermalCut = false;

    public BatteryInventoryProcess(BatteryElement battery) {
        this.battery = battery;
    }

    @Override
    public void process(double time) {
        if (!this.battery.descriptor.lifeEnable) {
            this.battery.batteryProcess.life = 1.0;
        }
        boolean cut = false;
        if (this.battery.hasOverHeatingProtection()) {
            if (this.battery.thermalLoad.Tc * 1.1 > this.battery.descriptor.thermalHeatTime) {
                this.thermalCut = true;
            }
            if (this.battery.thermalLoad.Tc * 1.15 < this.battery.descriptor.thermalHeatTime) {
                this.thermalCut = false;
            }
        } else {
            this.thermalCut = false;
        }
        if (this.thermalCut) {
            cut = true;
        }
        if (this.battery.hasOverVoltageProtection()) {
            if (this.battery.batteryProcess.getU() * 1.1 > this.battery.batterySlowProcess.getUMax() && this.battery.batteryProcess.getU() < this.battery.cutLoad.getU() - this.battery.negativeLoad.getU()) {
                cut = true;
            }
            if (this.battery.batteryProcess.getU() < this.battery.batteryProcess.uNominal * 0.001 && this.battery.batteryProcess.getU() > this.battery.cutLoad.getU() - this.battery.negativeLoad.getU()) {
                cut = true;
            }
        }
        this.battery.cutSwitch.setState(!cut);
        double U = this.battery.positiveLoad.getU() - this.battery.negativeLoad.getU();
        double currentDropPower = (U - this.battery.descriptor.currentDropVoltage) / this.battery.descriptor.electricalU * this.battery.descriptor.currentDropFactor;
        if (currentDropPower > 0.1) {
            this.battery.dischargeResistor.setR(1.0 / (1.0 / this.battery.descriptor.electricalRp + 1.0 / (U * U / currentDropPower)));
        } else {
            this.battery.dischargeResistor.setR(this.battery.descriptor.electricalRp);
        }
    }
}

