/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDUMask;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.transparentnode.battery.BatteryDescriptor;
import mods.eln.transparentnode.battery.BatteryGuiDraw;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class BatteryRender
extends TransparentNodeElementRender {
    public float energy;
    public float life;
    public BatteryDescriptor descriptor;
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(2, 64, this);
    boolean plus;
    boolean minus;
    LRDUMask lrdu = new LRDUMask();
    float power;

    public BatteryRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (BatteryDescriptor)descriptor;
    }

    @Override
    public void draw() {
        this.front.glRotateXnRef();
        this.descriptor.draw(this.plus, this.minus);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.power = stream.readFloat();
            this.energy = stream.readFloat();
            this.life = (float)stream.readShort() / 1000.0f;
            this.lrdu.deserialize(stream);
            this.plus = true;
            this.minus = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new BatteryGuiDraw(player, (IInventory)this.inventory, this);
    }
}

