/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.eggincubator;

import java.util.List;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.eggincubator.EggIncubatorElement;
import mods.eln.transparentnode.eggincubator.EggIncubatorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class EggIncubatorDescriptor
extends TransparentNodeDescriptor {
    Obj3D obj;
    Obj3D defaultFeroObj;
    public ElectricalCableDescriptor cable;
    private Obj3D.Obj3DPart lamp;
    private EntityItem eggEntity;
    private Obj3D.Obj3DPart lampf;
    Obj3D.Obj3DPart main;
    double nominalVoltage;
    double nominalPower;
    double Rp;

    public EggIncubatorDescriptor(String name, Obj3D obj, ElectricalCableDescriptor cable, double nominalVoltage, double nominalPower) {
        super(name, EggIncubatorElement.class, EggIncubatorRender.class);
        this.obj = obj;
        this.cable = cable;
        this.nominalVoltage = nominalVoltage;
        this.nominalPower = nominalPower;
        this.Rp = nominalVoltage * nominalVoltage / nominalPower;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.lamp = obj.getPart("lamp");
            this.lampf = obj.getPart("lampf");
        }
        this.voltageLevelColor = VoltageLevelColor.fromCable(cable);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addMachine(this.newItemStack());
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(0, 1.0f);
        }
    }

    void draw(int eggStackSize, float powerFactor) {
        if (eggStackSize == 0) {
            powerFactor = 0.0f;
        }
        UtilsClient.disableCulling();
        if (this.main != null) {
            this.main.draw();
        }
        if (this.lampf != null) {
            GL11.glColor3f((float)0.1f, (float)0.1f, (float)0.1f);
            this.lampf.draw();
        }
        if (this.lamp != null) {
            UtilsClient.disableLight();
            UtilsClient.enableBlend();
            GL11.glColor4f((float)1.0f, (float)0.2f, (float)0.0f, (float)(powerFactor * powerFactor * 0.5f));
            this.lamp.draw();
            UtilsClient.disableBlend();
            UtilsClient.enableLight();
        }
        UtilsClient.enableCulling();
    }

    public void applyTo(NbtElectricalLoad powerLoad) {
        this.cable.applyTo(powerLoad);
    }

    public void setState(Resistor powerLoad, boolean enable) {
        if (enable) {
            powerLoad.setR(this.Rp);
        } else {
            powerLoad.setR(1.0E9);
        }
    }

    @Override
    public void addCollisionBoxesToList(AxisAlignedBB par5AxisAlignedBB, List list, TransparentNodeEntity entity) {
        AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(entity.func_145831_w(), entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
        bb.field_72337_e -= 0.5;
        if (par5AxisAlignedBB.func_72326_a(bb)) {
            list.add(bb);
        }
    }
}

