/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.eggincubator;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.UtilsClient;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.transparentnode.eggincubator.EggIncubatorDescriptor;
import mods.eln.transparentnode.eggincubator.EggIncubatorGuiDraw;
import mods.eln.transparentnode.eggincubator.EggIncubatorInventory;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class EggIncubatorRender
extends TransparentNodeElementRender {
    TransparentNodeElementInventory inventory = new EggIncubatorInventory(1, 64, this);
    EggIncubatorDescriptor descriptor;
    float alpha = 0.0f;
    byte eggStackSize;
    EntityItem egg;
    public float voltage;
    LRDUMask priConn = new LRDUMask();
    LRDUMask secConn = new LRDUMask();
    LRDUMask eConn = new LRDUMask();
    CableRenderType cableRenderType;

    public EggIncubatorRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (EggIncubatorDescriptor)descriptor;
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        if (this.egg != null) {
            UtilsClient.drawEntityItem(this.egg, 0.0, -0.3f, 0.13f, this.alpha, 0.6f);
        }
        this.descriptor.draw(this.eggStackSize, (float)((double)this.voltage / this.descriptor.nominalVoltage));
        GL11.glPopMatrix();
        this.cableRenderType = this.drawCable(this.front.down(), this.descriptor.cable.render, this.eConn, this.cableRenderType);
    }

    @Override
    public void refresh(float deltaT) {
        this.alpha += deltaT * 60.0f;
        if (this.alpha >= 360.0f) {
            this.alpha -= 360.0f;
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new EggIncubatorGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.eggStackSize = stream.readByte();
            this.egg = this.eggStackSize != 0 ? new EntityItem(this.tileEntity.func_145831_w(), 0.0, 0.0, 0.0, new ItemStack(Items.field_151110_aK)) : null;
            this.eConn.deserialize(stream);
            this.voltage = stream.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.cableRenderType = null;
    }

    @Override
    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        return this.descriptor.cable.render;
    }

    @Override
    public void notifyNeighborSpawn() {
        super.notifyNeighborSpawn();
        this.cableRenderType = null;
    }
}

