/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalantennarx;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxElement;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalAntennaRxDescriptor
extends TransparentNodeDescriptor {
    Obj3D obj;
    Obj3D.Obj3DPart main;
    double electricalNominalVoltage;
    double electricalNominalPower;
    double electricalMaximalVoltage;
    double electricalMaximalPower;
    double electricalNominalInputR;
    ElectricalCableDescriptor cable;

    public ElectricalAntennaRxDescriptor(String name, Obj3D obj, double electricalNominalVoltage, double electricalNominalPower, double electricalMaximalVoltage, double electricalMaximalPower, ElectricalCableDescriptor cable) {
        super(name, ElectricalAntennaRxElement.class, ElectricalAntennaRxRender.class);
        this.electricalNominalVoltage = electricalNominalVoltage;
        this.electricalNominalPower = electricalNominalPower;
        this.electricalMaximalVoltage = electricalMaximalVoltage;
        this.electricalMaximalPower = electricalMaximalPower;
        this.cable = cable;
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
        }
        this.changeDefaultIcon("electricalantennarx");
        this.voltageLevelColor = VoltageLevelColor.fromVoltage(electricalNominalVoltage);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    @Override
    public TransparentNode.FrontType getFrontType() {
        return TransparentNode.FrontType.BlockSideInv;
    }

    @Override
    public boolean mustHaveWallFrontInverse() {
        return true;
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    @Override
    public boolean mustHaveFloor() {
        return false;
    }

    public void draw() {
        GL11.glDisable((int)2884);
        if (this.main != null) {
            this.main.draw();
        }
        GL11.glEnable((int)2884);
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw();
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Wireless energy receiver.", new Object[0]));
        list.add(I18N.tr("Nominal usage:", new Object[0]));
        list.add("  " + I18N.tr("Voltage: %1$V", Utils.plotValue(this.electricalNominalVoltage)));
        list.add("  " + I18N.tr("Power: %1$W", Utils.plotValue(this.electricalNominalPower)));
    }
}

