/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalantennarx;

import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.PowerSource;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxDescriptor;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalAntennaRxElement
extends TransparentNodeElement {
    ElectricalAntennaRxSlowProcess slowProcess = new ElectricalAntennaRxSlowProcess(this);
    NbtElectricalLoad powerOut = new NbtElectricalLoad("powerOut");
    NbtElectricalGateInput signalIn = new NbtElectricalGateInput("signalIn");
    PowerSource powerSrc = new PowerSource("powerSrc", (State)this.powerOut);
    LRDU rot = LRDU.Up;
    Coordonate rxCoord = null;
    ElectricalAntennaRxDescriptor descriptor;

    public double getSignal() {
        return this.signalIn.getBornedU();
    }

    public void setPowerOut(double power) {
        this.powerSrc.setP(power);
    }

    public void rxDisconnect() {
        this.powerSrc.setP(0.0);
    }

    public ElectricalAntennaRxElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.slowProcessList.add(this.slowProcess);
        this.electricalLoadList.add(this.powerOut);
        this.electricalLoadList.add(this.signalIn);
        this.electricalComponentList.add(this.powerSrc);
        this.descriptor = (ElectricalAntennaRxDescriptor)descriptor;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return null;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return this.powerOut;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return this.signalIn;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return 0;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return 1;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return "";
    }

    @Override
    public String thermoMeterString(Direction side) {
        return "";
    }

    @Override
    public void initialize() {
        this.descriptor.cable.applyTo(this.powerOut);
        this.powerSrc.setUmax(this.descriptor.electricalMaximalVoltage * 2.0);
        this.powerSrc.setImax(this.descriptor.electricalMaximalVoltage * this.descriptor.electricalMaximalPower * 2.0);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.rot = this.rot.getNextClockwise();
            this.node.reconnect();
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.rot = LRDU.readFromNBT(nbt, "rot");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.rot.writeToNBT(nbt, "rot");
    }

    public boolean mustHaveFloor() {
        return false;
    }

    public boolean mustHaveCeiling() {
        return false;
    }

    public boolean mustHaveWall() {
        return false;
    }

    public boolean mustHaveWallFrontInverse() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        this.rot.serialize(stream);
        this.node.lrduCubeMask.getTranslate(this.front.getInverse()).serialize(stream);
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Receiving", this.powerSrc.getP() != 0.0 ? "Yes" : "No");
        if (Eln.wailaEasyMode) {
            info.put("Power Received", Utils.plotPower("", this.powerSrc.getP()));
            info.put("Effective Power", Utils.plotPower("", this.powerSrc.getEffectiveP()));
        }
        return info;
    }
}

