/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalantennatx;

import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtResistor;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxElement;
import mods.eln.transparentnode.electricalantennatx.ElectricalAntennaTxDescriptor;
import mods.eln.transparentnode.electricalantennatx.ElectricalAntennaTxElectricalProcess;
import mods.eln.transparentnode.electricalantennatx.ElectricalAntennaTxSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalAntennaTxElement
extends TransparentNodeElement {
    ElectricalAntennaTxSlowProcess slowProcess = new ElectricalAntennaTxSlowProcess(this);
    NbtElectricalLoad powerIn = new NbtElectricalLoad("powerIn");
    NbtElectricalGateInput commandIn = new NbtElectricalGateInput("commandIn");
    NbtElectricalGateOutput signalOut = new NbtElectricalGateOutput("signalOut");
    NbtElectricalGateOutputProcess signalOutProcess = new NbtElectricalGateOutputProcess("signalOutProcess", this.signalOut);
    NbtResistor powerResistor = new NbtResistor("powerResistor", this.powerIn, null);
    ElectricalAntennaTxElectricalProcess electricalProcess = new ElectricalAntennaTxElectricalProcess(this);
    LRDU rot = LRDU.Down;
    boolean placeBoot = true;
    ElectricalAntennaTxDescriptor descriptor;
    Coordonate rxCoord = null;
    ElectricalAntennaRxElement rxElement = null;
    double powerEfficency = 0.0;

    public ElectricalAntennaTxElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.powerIn.setAsPrivate();
        this.slowProcessList.add(this.slowProcess);
        this.electricalLoadList.add(this.powerIn);
        this.electricalLoadList.add(this.commandIn);
        this.electricalLoadList.add(this.signalOut);
        this.electricalComponentList.add(this.signalOutProcess);
        this.electricalComponentList.add(this.powerResistor);
        this.electricalProcessList.add(this.electricalProcess);
        this.descriptor = (ElectricalAntennaTxDescriptor)descriptor;
    }

    public void txDisconnect() {
        ElectricalAntennaRxElement rx = this.getRxElement();
        if (rx != null) {
            rx.rxDisconnect();
        }
        this.rxCoord = null;
        this.rxElement = null;
    }

    ElectricalAntennaRxElement getRxElement() {
        if (this.rxCoord == null) {
            return null;
        }
        if (this.rxElement == null) {
            NodeBase node = NodeManager.instance.getNodeFromCoordonate(this.rxCoord);
            if (node != null && node instanceof TransparentNode && ((TransparentNode)node).element instanceof ElectricalAntennaRxElement) {
                this.rxElement = (ElectricalAntennaRxElement)((TransparentNode)node).element;
            } else {
                this.rxCoord = null;
                Utils.println("ASSERT ElectricalAntennaRxElement getRxElement()");
            }
        }
        return this.rxElement;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return null;
        }
        if (side == this.front.applyLRDU(this.rot)) {
            return this.powerIn;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return this.signalOut;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return this.commandIn;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return 0;
        }
        if (side == this.front.applyLRDU(this.rot)) {
            return 1;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return 4;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return "";
    }

    @Override
    public String thermoMeterString(Direction side) {
        return "";
    }

    void calculatePowerInRp() {
        double cmd = this.commandIn.getNormalized();
        if (cmd == 0.0) {
            this.powerResistor.setR(1.0E9);
        } else {
            this.powerResistor.setR(this.descriptor.electricalNominalInputR / cmd);
        }
    }

    @Override
    public void initialize() {
        this.descriptor.cable.applyTo(this.powerIn);
        this.calculatePowerInRp();
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.rot = this.rot.getNextClockwise();
            this.node.reconnect();
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74767_n("rxCoordValid")) {
            this.rxCoord = new Coordonate();
            this.rxCoord.readFromNBT(nbt, "rxCoord");
        }
        this.rot = LRDU.readFromNBT(nbt, "rot");
        this.placeBoot = false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.rxCoord == null) {
            nbt.func_74757_a("rxCoordValid", false);
        } else {
            nbt.func_74757_a("rxCoordValid", true);
            this.rxCoord.writeToNBT(nbt, "rxCoord");
        }
        this.rot.writeToNBT(nbt, "rot");
    }

    @Override
    public void onBreakElement() {
        this.txDisconnect();
        super.onBreakElement();
    }

    public boolean mustHaveFloor() {
        return false;
    }

    public boolean mustHaveCeiling() {
        return false;
    }

    public boolean mustHaveWall() {
        return false;
    }

    public boolean mustHaveWallFrontInverse() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        this.rot.serialize(stream);
        this.node.lrduCubeMask.getTranslate(this.front.getInverse()).serialize(stream);
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Transmitting", this.commandIn.getNormalized() > 0.0 ? "Yes" : "No");
        info.put("Efficency", Utils.plotPercent("", this.powerEfficency));
        if (Eln.wailaEasyMode) {
            info.put("Power", Utils.plotPower("", this.powerIn.getI() * this.powerIn.getU()));
        }
        return info;
    }
}

