/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalantennatx;

import java.io.DataInputStream;
import mods.eln.Eln;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.transparentnode.electricalantennatx.ElectricalAntennaTxDescriptor;
import org.lwjgl.opengl.GL11;

public class ElectricalAntennaTxRender
extends TransparentNodeElementRender {
    ElectricalAntennaTxDescriptor descriptor;
    LRDUMask maskTemp = new LRDUMask();
    LRDU rot;
    LRDUMask lrduConnection = new LRDUMask();
    CableRenderType connectionType;
    boolean cableRefresh = false;

    public ElectricalAntennaTxRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (ElectricalAntennaTxDescriptor)descriptor;
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        this.rot.glRotateOnX();
        this.descriptor.draw();
        GL11.glPopMatrix();
        this.glCableTransforme(this.front.getInverse());
        this.descriptor.cable.bindCableTexture();
        if (this.cableRefresh) {
            this.cableRefresh = false;
            this.connectionType = CableRender.connectionType(this.tileEntity, this.lrduConnection, this.front.getInverse());
        }
        for (LRDU lrdu : LRDU.values()) {
            Utils.setGlColorFromDye(this.connectionType.otherdry[lrdu.toInt()]);
            if (!this.lrduConnection.get(lrdu)) continue;
            this.maskTemp.set(1 << lrdu.toInt());
            if (lrdu == this.rot) {
                CableRender.drawCable(this.descriptor.cable.render, this.maskTemp, this.connectionType);
                continue;
            }
            if (lrdu != this.rot.left() && lrdu != this.rot.right()) continue;
            CableRender.drawCable(Eln.instance.signalCableDescriptor.render, this.maskTemp, this.connectionType);
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        this.rot = LRDU.deserialize(stream);
        this.lrduConnection.deserialize(stream);
        this.cableRefresh = true;
    }

    @Override
    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return null;
        }
        if (side == this.front.applyLRDU(this.rot)) {
            return this.descriptor.cable.render;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return Eln.instance.signalCableDescriptor.render;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return Eln.instance.signalCableDescriptor.render;
        }
        return null;
    }

    @Override
    public void notifyNeighborSpawn() {
        super.notifyNeighborSpawn();
        this.cableRefresh = true;
    }
}

