/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalfurnace;

import java.util.Collections;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.IFunction;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ThermalLoad;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceElement;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class ElectricalFurnaceDescriptor
extends TransparentNodeDescriptor {
    public IFunction PfT;
    public IFunction thermalPlostfT;
    public double thermalC;

    public ElectricalFurnaceDescriptor(String name, IFunction PfT, IFunction thermalPlostfT, double thermalC) {
        super(name, ElectricalFurnaceElement.class, ElectricalFurnaceRender.class);
        this.PfT = PfT;
        this.thermalPlostfT = thermalPlostfT;
        this.thermalC = thermalC;
    }

    public void applyTo(ThermalLoad load) {
        load.set(Double.POSITIVE_INFINITY, this.thermalPlostfT.getValue(0.0), this.thermalC);
    }

    public void refreshTo(ThermalLoad load, double conductionFactor) {
        double Rp = load.Tc / this.thermalPlostfT.getValue(load.Tc) / conductionFactor;
        if (Rp < 0.1) {
            Rp = 0.1;
        }
        load.setRp(Rp);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addMachine(this.newItemStack());
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public boolean use2DIcon() {
        return false;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Eln.obj.draw("ElectricFurnace", "furnace");
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Similar to a vanilla furnace,\nbut heats with electricity.", new Object[0]).split("\n"));
    }
}

