/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalfurnace;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamage;
import mods.eln.item.GenericItemUsingDamageDescriptorUpgrade;
import mods.eln.item.HeatingCorpElement;
import mods.eln.item.regulator.IRegulatorDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ElectricalResistorHeatThermalLoad;
import mods.eln.sim.RegulatorThermalLoadToElectricalResistor;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.ThermalResistor;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceContainer;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceDescriptor;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceInventory;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalFurnaceElement
extends TransparentNodeElement {
    TransparentNodeElementInventory inventory = new ElectricalFurnaceInventory(5, 64, this);
    public static final int inSlotId = 0;
    public static final int outSlotId = 1;
    public static final int heatingCorpSlotId = 2;
    public static final int thermalIsolatorSlotId = 3;
    public static final int thermalRegulatorSlotId = 4;
    NbtElectricalLoad electricalLoad = new NbtElectricalLoad("electricalLoad");
    ResistorSwitch heatingCorpResistor = new ResistorSwitch("heatResistor", this.electricalLoad, ElectricalLoad.groundLoad);
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    ThermalResistor smeltResistor = new ThermalResistor(this.thermalLoad, ThermalLoad.externalLoad);
    RegulatorThermalLoadToElectricalResistor thermalRegulator = new RegulatorThermalLoadToElectricalResistor("thermalRegulator", this.thermalLoad, this.heatingCorpResistor);
    ElectricalResistorHeatThermalLoad heatingCorpResistorHeatThermalLoad = new ElectricalResistorHeatThermalLoad(this.heatingCorpResistor, this.thermalLoad);
    ElectricalFurnaceProcess slowRefreshProcess = new ElectricalFurnaceProcess(this);
    boolean powerOn = false;
    boolean autoShutDown = true;
    ElectricalFurnaceDescriptor descriptor;
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();
    public static final byte unserializePowerOnId = 1;
    public static final byte unserializeTemperatureTarget = 2;
    public static final byte unserializeAutoShutDownId = 3;

    public ElectricalFurnaceElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (ElectricalFurnaceDescriptor)descriptor;
        this.electricalLoad.setAsPrivate();
        this.electricalLoadList.add(this.electricalLoad);
        this.electricalComponentList.add(this.heatingCorpResistor);
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalFastProcessList.add(this.smeltResistor);
        this.thermalFastProcessList.add(this.heatingCorpResistorHeatThermalLoad);
        this.thermalFastProcessList.add(this.thermalRegulator);
        this.slowProcessList.add(this.slowRefreshProcess);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.set(this.electricalLoad).set(exp));
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new ElectricalFurnaceContainer(this.node, player, (IInventory)this.inventory);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.electricalLoad;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (side == this.front.getInverse() && lrdu == LRDU.Down) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return Utils.plotUIP(this.electricalLoad.getU(), this.electricalLoad.getI());
    }

    @Override
    public String thermoMeterString(Direction side) {
        return Utils.plotCelsius("T:", this.thermalLoad.Tc);
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.thermalLoad);
        this.inventoryChange(this.getInventory());
        this.smeltResistor.highImpedance();
        this.slowRefreshProcess.process(0.05);
        Eln.instance.lowVoltageCableDescriptor.applyTo(this.electricalLoad);
        this.connect();
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        super.inventoryChange(inventory);
        this.setPhysicalValue();
        this.needPublish();
    }

    public void setPhysicalValue() {
        GenericItemUsingDamageDescriptorUpgrade element;
        this.heatingCorpResistor.setState(this.powerOn);
        ItemStack itemStack = this.inventory.func_70301_a(2);
        if (itemStack == null) {
            this.thermalRegulator.setRmin(1.0E9);
            this.voltageWatchdog.setUNominal(100000.0);
        } else {
            element = (HeatingCorpElement)((GenericItemUsingDamage)itemStack.func_77973_b()).getDescriptor(itemStack);
            ((HeatingCorpElement)element).applyTo(this.thermalRegulator);
            this.voltageWatchdog.setUNominal(((HeatingCorpElement)element).electricalNominalU);
        }
        itemStack = this.inventory.func_70301_a(4);
        if (itemStack == null) {
            this.thermalRegulator.setNone();
        } else {
            element = (IRegulatorDescriptor)((GenericItemUsingDamage)itemStack.func_77973_b()).getDescriptor(itemStack);
            ((IRegulatorDescriptor)element).applyTo(this.thermalRegulator, 500.0, 10.0, 0.1, 0.1);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte((this.powerOn ? 1 : 0) + (this.heatingCorpResistor.getP() > 5.0 ? 2 : 0));
            stream.writeShort((int)this.thermalRegulator.getTarget());
            stream.writeShort((int)this.thermalLoad.Tc);
            ItemStack stack = this.inventory.func_70301_a(0);
            if (stack == null) {
                stream.writeShort(-1);
                stream.writeShort(-1);
            } else {
                stream.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
                stream.writeShort(stack.func_77960_j());
            }
            stream.writeShort((int)this.heatingCorpResistor.getP());
            stream.writeFloat((float)this.electricalLoad.getU());
            stream.writeFloat((float)this.slowRefreshProcess.processState());
            stream.writeFloat((float)this.slowRefreshProcess.processStatePerSecond());
            stream.writeBoolean(this.autoShutDown);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powerOn", this.powerOn);
        nbt.func_74757_a("autoShutDown", this.autoShutDown);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerOn = nbt.func_74767_n("powerOn");
        this.autoShutDown = nbt.func_74767_n("autoShutDown");
    }

    public void setPowerOn(boolean value) {
        if (this.powerOn != value) {
            this.powerOn = value;
            this.setPhysicalValue();
            this.needPublish();
        }
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        try {
            switch (packetType) {
                case 1: {
                    this.setPowerOn(stream.readByte() != 0);
                    break;
                }
                case 3: {
                    this.autoShutDown = !this.autoShutDown;
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.thermalRegulator.setTarget(stream.readFloat());
                    this.needPublish();
                    break;
                }
                default: {
                    return packetType;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -128;
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Temperature", Utils.plotCelsius("", this.thermalLoad.Tc));
        if (this.inventory.func_70301_a(2) != null) {
            info.put("Heating Element", this.inventory.func_70301_a(2).func_82833_r());
        }
        return info;
    }
}

