/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalfurnace;

import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiVerticalTrackBarHeat;
import mods.eln.gui.GuiVerticalVoltageSupplyBar;
import mods.eln.gui.HelperStdContainer;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.item.HeatingCorpElement;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceContainer;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ElectricalFurnaceGuiDraw
extends GuiContainerEln {
    private TransparentNodeElementInventory inventory;
    ElectricalFurnaceRender render;
    GuiButton buttonGrounded;
    GuiButton autoShutDown;
    GuiVerticalTrackBarHeat vuMeterTemperature;
    GuiVerticalVoltageSupplyBar supplyBar;

    public ElectricalFurnaceGuiDraw(EntityPlayer player, IInventory inventory, ElectricalFurnaceRender render) {
        super(new ElectricalFurnaceContainer(null, player, inventory));
        this.inventory = (TransparentNodeElementInventory)inventory;
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.autoShutDown = this.newGuiButton(6, 6, 99, "");
        this.buttonGrounded = this.newGuiButton(6, 30, 40, "");
        this.vuMeterTemperature = this.newGuiVerticalTrackBarHeat(115, 8, 20, 69);
        this.vuMeterTemperature.setStepIdMax(80);
        this.vuMeterTemperature.setEnable(true);
        this.vuMeterTemperature.setRange(0.0f, 800.0f);
        this.vuMeterTemperature.setComment(new String[]{I18N.tr("Temperature gauge", new Object[0])});
        this.syncVumeter();
        this.supplyBar = new GuiVerticalVoltageSupplyBar(145, 8, 20, 69, this.helper);
        this.add(this.supplyBar);
    }

    public void syncVumeter() {
        this.vuMeterTemperature.setValue(this.render.temperatureTargetSyncValue);
        this.render.temperatureTargetSyncNew = false;
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        this.buttonGrounded.field_146126_j = this.render.getPowerOn() ? I18N.tr("Is on", new Object[0]) : I18N.tr("Is off", new Object[0]);
        if (this.render.autoShutDown) {
            this.buttonGrounded.field_146124_l = false;
            this.autoShutDown.field_146126_j = I18N.tr("Auto shutdown", new Object[0]);
        } else {
            this.autoShutDown.field_146126_j = I18N.tr("Manual shutdown", new Object[0]);
            this.buttonGrounded.field_146124_l = true;
        }
        if (this.render.temperatureTargetSyncNew) {
            this.syncVumeter();
        }
        this.vuMeterTemperature.temperatureHit = this.render.temperature;
        this.vuMeterTemperature.setComment(1, I18N.tr("Actual: %1$\u00b0C", Utils.plotValue((double)this.render.temperature + 20.0)));
        this.vuMeterTemperature.setComment(2, I18N.tr("Set point: %1$\u00b0C", Utils.plotValue((double)this.vuMeterTemperature.getValue() + 20.0)));
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.buttonGrounded) {
            this.render.clientSetPowerOn(!this.render.getPowerOn());
        } else if (object == this.autoShutDown) {
            this.render.clientSendId((byte)3);
        } else if (object == this.vuMeterTemperature) {
            this.render.clientSetTemperatureTarget(this.vuMeterTemperature.getValue());
        }
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        super.postDraw(f, x, y);
        ((HelperStdContainer)this.helper).drawProcess(40, 57, this.render.processState);
        ItemStack stack = this.render.inventory.func_70301_a(2);
        if (stack == null) {
            this.supplyBar.setEnabled(false);
        } else {
            this.supplyBar.setEnabled(true);
            HeatingCorpElement desc = (HeatingCorpElement)HeatingCorpElement.getDescriptor(stack);
            this.supplyBar.setNominalU((float)desc.electricalNominalU);
        }
        this.supplyBar.setVoltage(this.render.voltage);
        this.supplyBar.setPower(this.render.heatingCorpResistorP);
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new HelperStdContainer((GuiScreen)this);
    }
}

