/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalfurnace;

import mods.eln.generic.GenericItemUsingDamage;
import mods.eln.item.ThermalIsolatorElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceElement;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class ElectricalFurnaceProcess
implements IProcess {
    ElectricalFurnaceElement furnace;
    TransparentNodeElementInventory inventory;
    public static final double energyNeededPerSmelt = 1000.0;
    ItemStack itemStackInOld = null;
    boolean smeltInProcess = false;
    double energyNeeded = 0.0;
    double energyCounter = 0.0;

    public ElectricalFurnaceProcess(ElectricalFurnaceElement furnace) {
        this.furnace = furnace;
        this.inventory = (TransparentNodeElementInventory)furnace.getInventory();
    }

    @Override
    public void process(double time) {
        ItemStack itemStack = this.inventory.func_70301_a(3);
        if (itemStack == null) {
            this.furnace.descriptor.refreshTo(this.furnace.thermalLoad, 1.0);
        } else {
            ThermalIsolatorElement element = (ThermalIsolatorElement)((GenericItemUsingDamage)itemStack.func_77973_b()).getDescriptor(itemStack);
            this.furnace.descriptor.refreshTo(this.furnace.thermalLoad, element.conductionFactor);
        }
        ItemStack itemStackIn = this.inventory.func_70301_a(0);
        ItemStack itemStackOut = this.inventory.func_70301_a(1);
        if (this.itemStackInOld != itemStackIn || !this.smeltCan() || !this.smeltInProcess) {
            this.smeltInit();
            this.itemStackInOld = itemStackIn;
        }
        if (this.smeltInProcess) {
            this.energyCounter += this.getPower() * time;
            if (this.energyCounter > this.energyNeeded) {
                this.energyCounter -= this.energyNeeded;
                this.smeltItem();
                this.smeltInit();
            }
        }
        if (!this.smeltInProcess) {
            this.furnace.smeltResistor.highImpedance();
        } else {
            double T = Math.abs(this.furnace.thermalLoad.Tc) + 1.0;
            double P = this.furnace.descriptor.PfT.getValue(T);
            this.furnace.smeltResistor.setR(T / P);
        }
        if (this.furnace.autoShutDown) {
            if (this.smeltInProcess) {
                this.furnace.setPowerOn(true);
            } else {
                this.furnace.setPowerOn(false);
            }
        }
        int i = 0;
        ++i;
    }

    double getPower() {
        return this.furnace.smeltResistor.getP();
    }

    public void smeltInit() {
        this.smeltInProcess = this.smeltCan();
        if (!this.smeltInProcess) {
            this.smeltInProcess = false;
            this.energyNeeded = 1.0;
            this.energyCounter = 0.0;
        } else {
            this.smeltInProcess = true;
            this.energyNeeded = 1000.0;
            this.energyCounter = 0.0;
        }
    }

    private boolean smeltCan() {
        if (this.inventory.func_70301_a(0) == null) {
            return false;
        }
        ItemStack var1 = this.getSmeltResult();
        if (var1 == null) {
            return false;
        }
        if (this.inventory.func_70301_a(1) == null) {
            return true;
        }
        if (!this.inventory.func_70301_a(1).func_77969_a(var1)) {
            return false;
        }
        int result = this.inventory.func_70301_a((int)1).field_77994_a + var1.field_77994_a;
        return result <= this.inventory.func_70297_j_() && result <= var1.func_77976_d();
    }

    public ItemStack getSmeltResult() {
        return FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.func_70301_a(0));
    }

    public void smeltItem() {
        if (this.smeltCan()) {
            ItemStack var1 = this.getSmeltResult();
            if (this.inventory.func_70301_a(1) == null) {
                this.inventory.func_70299_a(1, var1.func_77946_l());
            } else if (this.inventory.func_70301_a(1).func_77969_a(var1)) {
                this.inventory.func_70298_a(1, -var1.field_77994_a);
            }
            this.inventory.func_70298_a(0, 1);
        }
    }

    public double processState() {
        if (!this.smeltInProcess) {
            return 0.0;
        }
        double state = this.energyCounter / this.energyNeeded;
        if (state > 1.0) {
            state = 1.0;
        }
        return state;
    }

    public double processStatePerSecond() {
        if (!this.smeltInProcess) {
            return 0.0;
        }
        double power = this.getPower() + 0.1;
        double ret = power / this.energyNeeded;
        return ret;
    }
}

