/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.RecipesList;
import mods.eln.misc.UtilsClient;
import mods.eln.sim.ThermalLoadInitializer;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineRender;
import net.minecraft.entity.item.EntityItem;
import org.lwjgl.opengl.GL11;

public class CompressorDescriptor
extends ElectricalMachineDescriptor {
    float tyOn;
    float tyOff;
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart move;

    public CompressorDescriptor(String name, Obj3D obj, double nominalU, double nominalP, double maximalU, ThermalLoadInitializer thermal, ElectricalCableDescriptor cable, RecipesList recipe) {
        super(name, nominalU, nominalP, maximalU, thermal, cable, recipe);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.move = obj.getPart("move");
            if (this.move != null) {
                this.tyOn = this.move.getFloat("tyon");
                this.tyOff = this.move.getFloat("tyoff");
            }
        }
    }

    @Override
    Object newDrawHandle() {
        return new CompressorDescriptorHandle();
    }

    @Override
    void draw(ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
        CompressorDescriptorHandle handle = (CompressorDescriptorHandle)handleO;
        UtilsClient.drawEntityItem(inEntity, -0.35f, 0.04f, 0.3f, handle.itemCounter, 1.0f);
        UtilsClient.drawEntityItem(outEntity, 0.35f, 0.04f, 0.3f, -handle.itemCounter + 139.0f, 1.0f);
        this.main.draw();
        GL11.glTranslatef((float)0.0f, (float)(this.tyOff + (float)Math.sqrt(handle.interpolator.get()) * (this.tyOn - this.tyOff)), (float)0.0f);
        this.move.draw();
    }

    @Override
    void refresh(float deltaT, ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
        CompressorDescriptorHandle handle = (CompressorDescriptorHandle)handleO;
        handle.interpolator.setTarget(processState);
        handle.interpolator.step(deltaT);
        handle.itemCounter += deltaT * 90.0f;
        while (handle.itemCounter >= 360.0f) {
            handle.itemCounter -= 360.0f;
        }
    }

    @Override
    public boolean powerLrdu(Direction side, Direction front) {
        return side != front && side != front.getInverse();
    }

    class CompressorDescriptorHandle {
        RcInterpolator interpolator = new RcInterpolator(0.25f);
        float itemCounter = 0.0f;

        CompressorDescriptorHandle() {
        }
    }
}

