/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import java.util.List;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.gui.GuiLabel;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.Recipe;
import mods.eln.misc.RecipesList;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ElectricalStackMachineProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.ThermalLoadInitializer;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sound.SoundCommand;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineElement;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineRender;
import mods.eln.wiki.Data;
import mods.eln.wiki.GuiItemStack;
import mods.eln.wiki.GuiVerticalExtender;
import mods.eln.wiki.ItemDefault;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class ElectricalMachineDescriptor
extends TransparentNodeDescriptor
implements ItemDefault.IPlugIn {
    public RecipesList recipe = new RecipesList();
    double nominalU;
    double nominalP;
    ThermalLoadInitializer thermal;
    ElectricalCableDescriptor cable;
    int outStackCount = 4;
    double resistorR;
    double boosterEfficiency = 0.9090909090909091;
    double boosterSpeedUp = 1.25 / this.boosterEfficiency;
    SoundCommand runingSound;
    SoundCommand endSound;
    double maximalU;
    Object defaultHandle = null;

    public ElectricalMachineDescriptor(String name, double nominalU, double nominalP, double maximalU, ThermalLoadInitializer thermal, ElectricalCableDescriptor cable, RecipesList recipe) {
        super(name, ElectricalMachineElement.class, ElectricalMachineRender.class);
        this.nominalP = nominalP;
        this.nominalU = nominalU;
        this.maximalU = maximalU;
        this.cable = cable;
        this.thermal = thermal;
        this.resistorR = nominalU * nominalU / nominalP;
        this.recipe = recipe;
    }

    public ElectricalMachineDescriptor setRuningSound(SoundCommand runingSound) {
        this.runingSound = runingSound;
        return this;
    }

    @Override
    public boolean use2DIcon() {
        return false;
    }

    public ElectricalMachineDescriptor setEndSound(SoundCommand endSound) {
        this.endSound = endSound;
        return this;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        this.recipe.addMachine(this.newItemStack(1));
        Data.addMachine(this.newItemStack(1));
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Nominal voltage: %1$V", Utils.plotValue(this.nominalU)));
        list.add(I18N.tr("Nominal power: %1$W", Utils.plotValue(this.nominalP)));
    }

    public void applyTo(ElectricalLoad load) {
        this.cable.applyTo(load);
    }

    public void applyTo(Resistor resistor) {
        resistor.setR(this.resistorR);
    }

    public void applyTo(ElectricalStackMachineProcess machine) {
        machine.setResistorValue(this.resistorR);
    }

    public void applyTo(ThermalLoad load) {
        this.thermal.applyTo(load);
    }

    Object newDrawHandle() {
        return null;
    }

    void draw(ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
    }

    void refresh(float deltaT, ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
    }

    public boolean powerLrdu(Direction side, Direction front) {
        return true;
    }

    public boolean drawCable() {
        return false;
    }

    CableRenderDescriptor getPowerCableRender() {
        return null;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.draw(null, this.getDefaultHandle(), null, null, 0.0f, 0.0f);
    }

    Object getDefaultHandle() {
        if (this.defaultHandle == null) {
            this.defaultHandle = this.newDrawHandle();
        }
        return this.defaultHandle;
    }

    @Override
    public int top(int y, GuiVerticalExtender extender, ItemStack stack) {
        return y;
    }

    @Override
    public int bottom(int y, GuiVerticalExtender extender, ItemStack stack) {
        int counter = -1;
        extender.add(new GuiLabel(6, y, I18N.tr("Can create:", new Object[0])));
        y += 12;
        for (Recipe r : this.recipe.getRecipes()) {
            if (counter == 0) {
                y += 23;
            }
            if (counter == -1) {
                counter = 0;
            }
            int x = 6 + counter * 60;
            extender.add(new GuiItemStack(x, y, r.input, extender.helper));
            x += 36;
            for (ItemStack m : this.recipe.getMachines()) {
                extender.add(new GuiItemStack(x, y, m, extender.helper));
                x += 18;
            }
            extender.add(new GuiItemStack(x += 18, y, r.getOutputCopy()[0], extender.helper));
            extender.add(new GuiLabel(x += 22, y + 4, Utils.plotEnergy(I18N.tr("Cost", new Object[0]), r.energy)));
            counter = (counter + 1) % 1;
        }
        return y += 23;
    }
}

