/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDUMask;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineGuiDraw;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineInventory;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public class ElectricalMachineRender
extends TransparentNodeElementRender {
    TransparentNodeElementInventory inventory;
    ElectricalMachineDescriptor descriptor;
    Object drawHandle;
    private CableRenderType connectionType;
    LRDUMask eConn = new LRDUMask();
    LRDUMask maskTemp = new LRDUMask();
    float counter = 0.0f;
    EntityItem inEntity;
    EntityItem outEntity;
    float powerFactor;
    float processState;
    float processStatePerSecond;
    float UFactor;

    public ElectricalMachineRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (ElectricalMachineDescriptor)descriptor;
        this.inventory = new ElectricalMachineInventory(2 + this.descriptor.outStackCount, 64, this);
        this.drawHandle = this.descriptor.newDrawHandle();
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        this.descriptor.draw(this, this.drawHandle, this.inEntity, this.outEntity, this.powerFactor, this.processState);
        GL11.glPopMatrix();
        if (this.descriptor.drawCable()) {
            this.connectionType = this.drawCable(this.front.down(), this.descriptor.getPowerCableRender(), this.eConn, this.connectionType);
        }
    }

    @Override
    public void refresh(float deltaT) {
        this.processState += this.processStatePerSecond * deltaT;
        if (this.processState > 1.0f) {
            this.processState = 1.0f;
        }
        this.descriptor.refresh(deltaT, this, this.drawHandle, this.inEntity, this.outEntity, this.powerFactor, this.processState);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalMachineGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.powerFactor = (float)stream.readByte() / 64.0f;
            this.inEntity = this.unserializeItemStackToEntityItem(stream, this.inEntity);
            this.outEntity = this.unserializeItemStackToEntityItem(stream, this.outEntity);
            this.processState = stream.readFloat();
            this.processStatePerSecond = stream.readFloat();
            this.eConn.deserialize(stream);
            this.UFactor = stream.readFloat();
            this.connectionType = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notifyNeighborSpawn() {
        super.notifyNeighborSpawn();
        this.connectionType = null;
    }
}

