/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import mods.eln.sim.IProcess;
import mods.eln.sound.SoundCommand;
import mods.eln.sound.SoundLooper;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineElement;

public class ElectricalMachineSlowProcess
implements IProcess {
    private ElectricalMachineElement element;
    double lastPublishAt = 0.0;
    double lastUpdate = 0.0;
    boolean boot = true;
    SoundLooper sound;

    public ElectricalMachineSlowProcess(ElectricalMachineElement e) {
        this.element = e;
        this.sound = new SoundLooper(e){

            @Override
            public SoundCommand mustStart() {
                double P = ((ElectricalMachineSlowProcess)ElectricalMachineSlowProcess.this).element.electricalResistor.getP();
                double normalisedP = Math.pow(P / ((ElectricalMachineSlowProcess)ElectricalMachineSlowProcess.this).element.descriptor.nominalP, 0.5);
                if (((ElectricalMachineSlowProcess)ElectricalMachineSlowProcess.this).element.descriptor.runingSound == null || normalisedP < 0.3) {
                    return null;
                }
                float pitch = (float)normalisedP;
                return ((ElectricalMachineSlowProcess)ElectricalMachineSlowProcess.this).element.descriptor.runingSound.copy().mulVolume((float)normalisedP, pitch);
            }
        };
    }

    @Override
    public void process(double time) {
        double P = this.element.electricalResistor.getP();
        this.lastUpdate += time;
        if (!this.boot && Math.abs((P - this.lastPublishAt) / (this.lastPublishAt + 1.0)) > 0.03125 && this.lastUpdate > 0.2) {
            this.element.needPublish();
            this.lastPublishAt = P;
            this.lastUpdate = 0.0;
        }
        this.sound.process(time);
        this.boot = false;
    }
}

