/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.RecipesList;
import mods.eln.misc.UtilsClient;
import mods.eln.sim.ThermalLoadInitializer;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineRender;
import net.minecraft.entity.item.EntityItem;
import org.lwjgl.opengl.GL11;

public class MaceratorDescriptor
extends ElectricalMachineDescriptor {
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart rot1;
    Obj3D.Obj3DPart rot2;

    public MaceratorDescriptor(String name, String modelName, double nominalU, double nominalP, double maximalU, ThermalLoadInitializer thermal, ElectricalCableDescriptor cable, RecipesList recipe) {
        super(name, nominalU, nominalP, maximalU, thermal, cable, recipe);
        this.obj = Eln.obj.getObj(modelName);
        if (this.obj != null) {
            this.rot1 = this.obj.getPart("rot1");
            this.rot2 = this.obj.getPart("rot2");
            this.main = this.obj.getPart("main");
        }
    }

    @Override
    Object newDrawHandle() {
        return new MaceratorDescriptorHandle();
    }

    @Override
    void draw(ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
        MaceratorDescriptorHandle handle = (MaceratorDescriptorHandle)handleO;
        this.main.draw();
        this.rot1.draw(handle.counter, 0.0f, 0.0f, -1.0f);
        this.rot2.draw(handle.counter, 0.0f, 0.0f, 1.0f);
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        UtilsClient.drawEntityItem(inEntity, 0.0, 0.4f, 0.0, handle.itemCounter, 1.0f);
        UtilsClient.drawEntityItem(outEntity, 0.0, -0.5, 0.0, 130.0f + handle.itemCounter, 1.0f);
    }

    @Override
    void refresh(float deltaT, ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
        MaceratorDescriptorHandle handle = (MaceratorDescriptorHandle)handleO;
        handle.interpolator.setTarget(powerFactor);
        handle.interpolator.step(deltaT);
        handle.counter += deltaT * handle.interpolator.get() * 180.0f;
        while (handle.counter >= 360.0f) {
            handle.counter -= 360.0f;
        }
        handle.itemCounter += deltaT * 90.0f;
        while (handle.itemCounter >= 360.0f) {
            handle.itemCounter -= 360.0f;
        }
    }

    @Override
    public boolean powerLrdu(Direction side, Direction front) {
        return side != front && side != front.getInverse();
    }

    class MaceratorDescriptorHandle {
        float counter = 0.0f;
        float itemCounter = 0.0f;
        RcInterpolator interpolator = new RcInterpolator(0.5f);

        MaceratorDescriptorHandle() {
        }
    }
}

