/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.heatfurnace;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mods.eln.item.regulator.IRegulatorDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtFurnaceProcess;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceContainer;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceDescriptor;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceInventory;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceInventoryProcess;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceThermalProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class HeatFurnaceElement
extends TransparentNodeElement {
    public NbtElectricalGateInput electricalCmdLoad = new NbtElectricalGateInput("electricalCmdLoad");
    public NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    public NbtFurnaceProcess furnaceProcess = new NbtFurnaceProcess("furnaceProcess", this.thermalLoad);
    public HeatFurnaceInventoryProcess inventoryProcess = new HeatFurnaceInventoryProcess(this);
    TransparentNodeElementInventory inventory = new HeatFurnaceInventory(4, 64, this);
    HeatFurnaceThermalProcess regulator = new HeatFurnaceThermalProcess("regulator", this.furnaceProcess, this);
    HeatFurnaceDescriptor descriptor;
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();
    public static final byte unserializeGain = 1;
    public static final byte unserializeTemperatureTarget = 2;
    public static final byte unserializeToogleControlExternalId = 3;
    public static final byte unserializeToogleTakeFuelId = 4;
    public boolean controlExternal = false;
    public boolean takeFuel = false;

    public HeatFurnaceElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (HeatFurnaceDescriptor)descriptor;
        this.furnaceProcess.setGainMin(0.1);
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalFastProcessList.add(this.furnaceProcess);
        this.slowProcessList.add(this.inventoryProcess);
        this.thermalFastProcessList.add(this.regulator);
        this.electricalLoadList.add(this.electricalCmdLoad);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 2.0, 1.0));
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setLimit(this.descriptor.thermal).set(new WorldExplosion(this).machineExplosion());
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.electricalCmdLoad;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        if (side == this.front.getInverse() && lrdu == LRDU.Down) {
            return this.thermalLoad;
        }
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if ((side == this.front.left() || side == this.front.right()) && lrdu == LRDU.Down) {
            return 4;
        }
        if (side == this.front.getInverse() && lrdu == LRDU.Down) {
            return 2;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return "";
    }

    @Override
    public String thermoMeterString(Direction side) {
        return Utils.plotCelsius("T:", this.thermalLoad.Tc);
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.thermalLoad);
        this.descriptor.applyTo(this.furnaceProcess);
        this.computeInventory();
        this.connect();
        this.inventoryProcess.process(0.05);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.getControlExternal());
            stream.writeBoolean(this.getTakeFuel());
            stream.writeShort((short)(this.thermalLoad.Tc * 10.0));
            stream.writeFloat((float)this.furnaceProcess.getGain());
            stream.writeFloat((float)this.regulator.getTarget());
            stream.writeShort((int)this.furnaceProcess.getP());
            this.serialiseItemStack(stream, this.inventory.func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new HeatFurnaceContainer(this.node, player, (IInventory)this.inventory, this.descriptor);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        try {
            switch (packetType) {
                case 1: {
                    if (this.inventory.func_70301_a(1) == null) {
                        this.furnaceProcess.setGain(stream.readFloat());
                    }
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.regulator.setTarget(stream.readFloat());
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.regulator.setTarget(0.0);
                    this.setControlExternal(!this.getControlExternal());
                    break;
                }
                case 4: {
                    this.setTakeFuel(!this.getTakeFuel());
                    break;
                }
                default: {
                    return packetType;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -128;
    }

    public boolean getControlExternal() {
        return this.controlExternal;
    }

    public void setControlExternal(boolean value) {
        if (value != this.controlExternal) {
            this.needPublish();
        }
        this.controlExternal = value;
        this.computeInventory();
    }

    public boolean getTakeFuel() {
        return this.takeFuel;
    }

    public void setTakeFuel(boolean value) {
        if (value != this.takeFuel) {
            this.needPublish();
        }
        this.takeFuel = value;
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        super.inventoryChange(inventory);
        this.computeInventory();
        this.needPublish();
    }

    void computeInventory() {
        ItemStack regulatorStack = this.inventory.func_70301_a(1);
        if (regulatorStack != null && !this.controlExternal) {
            IRegulatorDescriptor regulator = (IRegulatorDescriptor)Utils.getItemObject(regulatorStack);
            regulator.applyTo(this.regulator, 500.0, 10.0, 0.1, 0.1);
        } else {
            this.regulator.setManuel();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("takeFuel", this.takeFuel);
        nbt.func_74757_a("controlExternal", this.controlExternal);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.takeFuel = nbt.func_74767_n("takeFuel");
        this.controlExternal = nbt.func_74767_n("controlExternal");
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        DecimalFormat format = new DecimalFormat("#.#");
        info.put("Temperature", Utils.plotCelsius("", this.thermalLoad.Tc));
        info.put("Target Temp", Utils.plotCelsius("", this.regulator.getTarget()));
        return info;
    }
}

