/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.heatfurnace;

import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiVerticalTrackBar;
import mods.eln.gui.GuiVerticalTrackBarHeat;
import mods.eln.gui.HelperStdContainer;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceContainer;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class HeatFurnaceGuiDraw
extends GuiContainerEln {
    private TransparentNodeElementInventory inventory;
    HeatFurnaceRender render;
    GuiButton externalControl;
    GuiButton takeFuel;
    GuiVerticalTrackBar vuMeterGain;
    GuiVerticalTrackBarHeat vuMeterHeat;

    public HeatFurnaceGuiDraw(EntityPlayer player, IInventory inventory, HeatFurnaceRender render) {
        super(new HeatFurnaceContainer(null, player, inventory, render.descriptor));
        this.inventory = (TransparentNodeElementInventory)inventory;
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.externalControl = this.newGuiButton(6, 6, 100, "");
        this.takeFuel = this.newGuiButton(6, 30, 100, "");
        this.vuMeterGain = this.newGuiVerticalTrackBar(144, 8, 20, 69);
        this.vuMeterGain.setStepIdMax(90);
        this.vuMeterGain.setEnable(true);
        this.vuMeterGain.setRange(0.1f, 1.0f);
        this.syncVumeterGain();
        this.vuMeterHeat = this.newGuiVerticalTrackBarHeat(116, 8, 20, 69);
        this.vuMeterHeat.setStepIdMax(98);
        this.vuMeterHeat.setEnable(true);
        this.vuMeterHeat.setRange(0.0f, 980.0f);
        this.vuMeterHeat.setComment(0, I18N.tr("Temperature gauge", new Object[0]));
        this.syncVumeterHeat();
    }

    public void syncVumeterGain() {
        this.vuMeterGain.setValue(this.render.gainSyncValue);
        this.render.gainSyncNew = false;
    }

    public void syncVumeterHeat() {
        this.vuMeterHeat.setValue(this.render.temperatureTargetSyncValue);
        this.render.temperatureTargetSyncNew = false;
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        this.externalControl.field_146126_j = !this.render.controleExternal ? I18N.tr("Internal control", new Object[0]) : I18N.tr("External control", new Object[0]);
        this.takeFuel.field_146126_j = this.render.takeFuel ? I18N.tr("Take fuel", new Object[0]) : I18N.tr("Decline fuel", new Object[0]);
        this.takeFuel.field_146124_l = !this.render.controleExternal;
        this.vuMeterGain.setEnable(this.inventory.func_70301_a(1) == null && !this.render.controleExternal);
        if (this.render.gainSyncNew) {
            this.syncVumeterGain();
        }
        this.vuMeterHeat.setEnable(this.inventory.func_70301_a(1) != null && !this.render.controleExternal);
        if (this.render.temperatureTargetSyncNew) {
            this.syncVumeterHeat();
        }
        this.vuMeterHeat.temperatureHit = (float)this.render.temperature;
        this.vuMeterHeat.setComment(new String[0]);
        this.vuMeterHeat.setComment(0, I18N.tr("Temperature gauge", new Object[0]));
        this.vuMeterHeat.setComment(1, I18N.tr("Actual: %1$\u00b0C", Utils.plotValue(this.render.temperature)));
        if (!this.render.controleExternal) {
            this.vuMeterHeat.setComment(2, Utils.plotCelsius("Set point:", this.vuMeterHeat.getValue()));
        }
        this.vuMeterGain.setComment(0, I18N.tr("Control gauge at %1$%", (int)this.vuMeterGain.getValue() * 100));
        this.vuMeterGain.setComment(1, I18N.tr("Power: %1$W", this.render.power));
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.externalControl) {
            this.render.clientToogleControl();
        } else if (object == this.takeFuel) {
            this.render.clientToogleTakeFuel();
        } else if (this.vuMeterGain == object) {
            this.render.clientSetGain(this.vuMeterGain.getValue());
        } else if (this.vuMeterHeat == object) {
            this.render.clientSetTemperatureTarget(this.vuMeterHeat.getValue());
        }
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        super.postDraw(f, x, y);
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new HelperStdContainer((GuiScreen)this);
    }
}

