/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.heatfurnace;

import mods.eln.generic.GenericItemUsingDamage;
import mods.eln.item.ThermalIsolatorElement;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.server.SaveConfig;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceElement;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class HeatFurnaceInventoryProcess
implements IProcess,
INBTTReady {
    HeatFurnaceElement furnace;
    double combustibleBuffer = 0.0;

    public HeatFurnaceInventoryProcess(HeatFurnaceElement furnace) {
        this.furnace = furnace;
    }

    @Override
    public void process(double time) {
        ItemStack combustibleStack = this.furnace.inventory.func_70301_a(0);
        ItemStack combustionChamberStack = this.furnace.inventory.func_70301_a(3);
        ItemStack isolatorChamberStack = this.furnace.inventory.func_70301_a(2);
        double isolationFactor = 1.0;
        if (isolatorChamberStack != null) {
            ThermalIsolatorElement iso = (ThermalIsolatorElement)((GenericItemUsingDamage)isolatorChamberStack.func_77973_b()).getDescriptor(isolatorChamberStack);
            isolationFactor = iso.conductionFactor;
        }
        this.furnace.thermalLoad.setRp(this.furnace.descriptor.thermal.Rp / isolationFactor);
        int combustionChamberNbr = 0;
        if (combustionChamberStack != null) {
            combustionChamberNbr = combustionChamberStack.field_77994_a;
        }
        this.furnace.furnaceProcess.nominalPower = this.furnace.descriptor.nominalPower + this.furnace.descriptor.combustionChamberPower * (double)combustionChamberNbr;
        if (this.furnace.getTakeFuel() && SaveConfig.instance != null) {
            double itemEnergy;
            if (!SaveConfig.instance.heatFurnaceFuel) {
                this.combustibleBuffer = this.furnace.furnaceProcess.nominalCombustibleEnergy;
            } else if (combustibleStack != null && (itemEnergy = Utils.getItemEnergie(combustibleStack)) != 0.0 && this.furnace.furnaceProcess.combustibleEnergy + this.combustibleBuffer < this.furnace.furnaceProcess.nominalCombustibleEnergy) {
                this.combustibleBuffer += itemEnergy;
                this.furnace.inventory.func_70298_a(0, 1);
                if (combustibleStack.func_77973_b().func_77658_a().toLowerCase().contains("bucket")) {
                    this.furnace.inventory.func_70299_a(0, new ItemStack(Items.field_151133_ar));
                }
            }
        }
        if (this.furnace.furnaceProcess.combustibleEnergy + this.combustibleBuffer < this.furnace.furnaceProcess.nominalCombustibleEnergy) {
            this.furnace.furnaceProcess.combustibleEnergy += this.combustibleBuffer;
            this.combustibleBuffer = 0.0;
        } else {
            double delta = this.furnace.furnaceProcess.nominalCombustibleEnergy - this.furnace.furnaceProcess.combustibleEnergy;
            this.furnace.furnaceProcess.combustibleEnergy += delta;
            this.combustibleBuffer -= delta;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.combustibleBuffer = nbt.func_74769_h(str + "HFIPcombustribleBuffer");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74780_a(str + "HFIPcombustribleBuffer", this.combustibleBuffer);
    }
}

