/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.solarpanel;

import java.util.List;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.ghost.GhostGroup;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.IFunction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.sim.ElectricalLoad;
import mods.eln.transparentnode.solarpanel.SolarPanelElement;
import mods.eln.transparentnode.solarpanel.SolarPanelRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class SolarPanelDescriptor
extends TransparentNodeDescriptor {
    boolean basicModel;
    private Obj3D obj;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart panneau;
    private Obj3D.Obj3DPart foot;
    CableRenderDescriptor cableRender;
    double electricalUmax;
    double electricalPmax;
    int solarOffsetX;
    int solarOffsetY;
    int solarOffsetZ;
    double alphaMin;
    double alphaMax;
    double electricalRs;
    IFunction diodeIfU;
    FunctionTable solarIfS;
    boolean canRotate;

    public SolarPanelDescriptor(String name, Obj3D obj, CableRenderDescriptor cableRender, GhostGroup ghostGroup, int solarOffsetX, int solarOffsetY, int solarOffsetZ, double electricalUmax, double electricalPmax, double electricalDropFactor, double alphaMin, double alphaMax) {
        super(name, SolarPanelElement.class, SolarPanelRender.class);
        this.ghostGroup = ghostGroup;
        this.electricalRs = electricalUmax * electricalUmax * electricalDropFactor / electricalPmax / 2.0;
        this.electricalPmax = electricalPmax;
        this.solarOffsetX = solarOffsetX;
        this.solarOffsetY = solarOffsetY;
        this.solarOffsetZ = solarOffsetZ;
        this.alphaMax = alphaMax;
        this.alphaMin = alphaMin;
        this.basicModel = true;
        this.electricalUmax = electricalUmax;
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.panneau = obj.getPart("panneau");
            this.foot = obj.getPart("foot");
        }
        this.cableRender = cableRender;
        this.canRotate = alphaMax != alphaMin;
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    public SolarPanelDescriptor(String name, GhostGroup ghostGroup, int solarOffsetX, int solarOffsetY, int solarOffsetZ, FunctionTable diodeIfUBase, FunctionTable solarIfSBase, double electricalUmax, double electricalImax, double electricalDropFactor, double alphaMin, double alphaMax) {
        super(name, SolarPanelElement.class, SolarPanelRender.class);
        this.ghostGroup = ghostGroup;
        this.diodeIfU = diodeIfUBase.duplicate(electricalUmax, electricalImax);
        this.electricalRs = electricalUmax * electricalImax * electricalDropFactor / electricalImax / electricalImax / 2.0;
        this.solarIfS = solarIfSBase.duplicate(1.0, electricalImax);
        this.solarOffsetX = solarOffsetX;
        this.solarOffsetY = solarOffsetY;
        this.solarOffsetZ = solarOffsetZ;
        this.alphaMax = alphaMax;
        this.alphaMin = alphaMin;
        this.basicModel = false;
        this.canRotate = alphaMax != alphaMin;
    }

    public void applyTo(ElectricalLoad load) {
        load.setRs(this.electricalRs);
    }

    public double alphaTrunk(double alpha) {
        if (alpha > this.alphaMax) {
            return this.alphaMax;
        }
        if (alpha < this.alphaMin) {
            return this.alphaMin;
        }
        return alpha;
    }

    void draw(float alpha, Direction front) {
        if (this.foot != null) {
            this.foot.draw();
        }
        if (this.panneau != null) {
            GL11.glPushMatrix();
            this.panneau.draw(alpha, 0.0f, 0.0f, 1.0f);
            GL11.glPopMatrix();
        }
        front.glRotateXnRef();
        if (this.main != null) {
            this.main.draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw((float)this.alphaMin, Direction.XN);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Produces power from solar radiation.", new Object[0]));
        list.add("  " + I18N.tr("Max. voltage: %1$V", Utils.plotValue(this.electricalUmax)));
        list.add("  " + I18N.tr("Max. power: %1$W", Utils.plotValue(this.electricalPmax)));
        if (this.canRotate) {
            list.add(I18N.tr("Can be geared towards the sun.", new Object[0]));
        }
    }

    @Override
    public void addCollisionBoxesToList(AxisAlignedBB par5AxisAlignedBB, List list, TransparentNodeEntity entity) {
        if (this.canRotate) {
            super.addCollisionBoxesToList(par5AxisAlignedBB, list, entity);
            return;
        }
        AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(entity.func_145831_w(), entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
        bb.field_72337_e -= 0.5;
        if (par5AxisAlignedBB.func_72326_a(bb)) {
            list.add(bb);
        }
    }
}

