/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.solarpanel;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.DiodeProcess;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.PowerSourceBipole;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.solarpanel.SolarPanelContainer;
import mods.eln.transparentnode.solarpanel.SolarPanelDescriptor;
import mods.eln.transparentnode.solarpanel.SolarPannelSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class SolarPanelElement
extends TransparentNodeElement {
    SolarPanelDescriptor descriptor;
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    VoltageSource positiveSrc = new VoltageSource("posSrc", this.positiveLoad, null);
    VoltageSource negativeSrc = new VoltageSource("negSrc", this.negativeLoad, null);
    DiodeProcess diode;
    PowerSourceBipole powerSource;
    SolarPannelSlowProcess slowProcess = new SolarPannelSlowProcess(this);
    public double pannelAlpha = 1.5707963267948966;
    public static final byte unserializePannelAlpha = 0;
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(1, 64, this);

    public SolarPanelElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (SolarPanelDescriptor)descriptor;
        this.grounded = false;
        this.powerSource = new PowerSourceBipole(this.positiveLoad, this.negativeLoad, this.positiveSrc, this.negativeSrc);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.positiveSrc);
        this.electricalComponentList.add(this.negativeSrc);
        this.slowProcessList.add(this.slowProcess);
    }

    @Override
    public void connectJob() {
        Eln.simulator.mna.addProcess(this.powerSource);
        super.connectJob();
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.powerSource);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.left()) {
            return this.positiveLoad;
        }
        if (side == this.front.right() && !this.grounded) {
            return this.negativeLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.front.left()) {
            return 1;
        }
        if (side == this.front.right() && !this.grounded) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return Utils.plotUIP(this.positiveLoad.getU() - this.negativeLoad.getU(), this.positiveLoad.getCurrent());
    }

    @Override
    public String thermoMeterString(Direction side) {
        return "";
    }

    @Override
    public void initialize() {
        this.powerSource.setUmax(this.descriptor.electricalUmax);
        this.powerSource.setImax(this.descriptor.electricalPmax / this.descriptor.electricalUmax * 1.5);
        this.descriptor.applyTo(this.positiveLoad);
        this.descriptor.applyTo(this.negativeLoad);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.powerSource.writeToNBT(nbt, "powerSource");
        nbt.func_74780_a("pannelAlpha", this.pannelAlpha);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerSource.readFromNBT(nbt, "powerSource");
        this.pannelAlpha = nbt.func_74769_h("pannelAlpha");
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.inventory.func_70301_a(0) != null);
            stream.writeFloat((float)this.pannelAlpha);
            this.node.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        try {
            switch (packetType) {
                case 0: {
                    this.pannelAlpha = stream.readFloat();
                    this.needPublish();
                    break;
                }
                default: {
                    return packetType;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -128;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return this.descriptor.canRotate;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new SolarPanelContainer(this.node, player, (IInventory)this.inventory);
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        DecimalFormat format = new DecimalFormat("#.##");
        info.put("Sun Angle", format.format(this.slowProcess.getSolarAlpha() * 57.29577951308232 - 90.0) + "\u00b0");
        info.put("Panel Angle", format.format(this.pannelAlpha * 57.29577951308232 - 90.0) + "\u00b0");
        info.put("Light", this.slowProcess.getSolarLight() != 0.0 ? "Yes" : "No");
        return info;
    }
}

