/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.solarpanel;

import mods.eln.misc.Coordonate;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.solarpanel.SolarPanelElement;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SolarPannelSlowProcess
implements IProcess {
    SolarPanelElement solarPannel;
    double timeCounter = 0.0;
    final double timeCounterRefreshMax = 0.2;

    public SolarPannelSlowProcess(SolarPanelElement solarPannel) {
        this.solarPannel = solarPannel;
    }

    @Override
    public void process(double time) {
        this.timeCounter -= time;
        if (this.timeCounter < 0.0) {
            this.solarPannel.powerSource.setP(this.solarPannel.descriptor.electricalPmax * this.getSolarLight());
            this.timeCounter += Math.random() * 0.2 / 2.0 + 0.1;
        }
    }

    public double getSolarLight() {
        double opacity;
        double solarAlpha = this.getSolarAlpha();
        if (solarAlpha >= Math.PI) {
            return 0.0;
        }
        if (this.solarPannel.inventory.func_70301_a(0) != null) {
            this.solarPannel.pannelAlpha = this.solarPannel.descriptor.alphaTrunk(solarAlpha);
        }
        Coordonate coordonate = this.solarPannel.node.coordonate;
        Vec3 v = Utils.getVec05(coordonate);
        double x = v.field_72450_a + (double)this.solarPannel.descriptor.solarOffsetX;
        double y = v.field_72448_b + (double)this.solarPannel.descriptor.solarOffsetY;
        double z = v.field_72449_c + (double)this.solarPannel.descriptor.solarOffsetZ;
        double lightAlpha = this.solarPannel.pannelAlpha - solarAlpha;
        double light = Math.cos(lightAlpha);
        if (light < 0.0) {
            light = 0.0;
        }
        if (!coordonate.getWorldExist()) {
            return light;
        }
        World world = coordonate.world();
        if (world.func_72912_H().func_76059_o()) {
            light *= 0.5;
        }
        if (world.func_72912_H().func_76061_m()) {
            light *= 0.5;
        }
        double xD = Math.cos(solarAlpha);
        double yD = Math.sin(solarAlpha);
        if (Math.abs(xD) > yD) {
            xD = Math.signum(xD);
            yD /= Math.abs(xD);
        } else {
            yD = 1.0;
            xD /= yD;
        }
        int count = 0;
        while (world.func_72863_F().func_73149_a((int)x >> 4, (int)z >> 4) && (light *= (255.0 - (opacity = (double)world.getBlockLightOpacity((int)x, (int)y, (int)z))) / 255.0) != 0.0) {
            x += xD;
            y += yD;
            ++count;
            if (!(y > 256.0)) continue;
            break;
        }
        return light;
    }

    public static double getSolarAlpha(World world) {
        double alpha = world.func_72929_e(0.0f);
        alpha = alpha < 4.71238898038469 ? (alpha += 1.5707963267948966) : (alpha -= 4.71238898038469);
        return alpha;
    }

    public double getSolarAlpha() {
        return SolarPannelSlowProcess.getSolarAlpha(this.solarPannel.node.coordonate.world());
    }
}

