/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.teleporter;

import mods.eln.ghost.GhostGroup;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.teleporter.TeleporterElement;
import mods.eln.transparentnode.teleporter.TeleporterRender;
import mods.eln.wiki.Data;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class TeleporterDescriptor
extends TransparentNodeDescriptor {
    private Obj3D obj;
    public Obj3D.Obj3DPart main;
    public Obj3D.Obj3DPart ext_control;
    public Obj3D.Obj3DPart ext_power;
    public Obj3D.Obj3DPart door_out;
    public Obj3D.Obj3DPart door_in;
    public Obj3D.Obj3DPart door_in_charge;
    public Obj3D.Obj3DPart indoor_open;
    public Obj3D.Obj3DPart indoor_closed;
    public Obj3D.Obj3DPart outlampline0_alpha;
    public Obj3D.Obj3DPart outlampline0;
    public Obj3D.Obj3DPart[] leds = new Obj3D.Obj3DPart[10];
    public Obj3D.Obj3DPart scr0_electrictity;
    public Obj3D.Obj3DPart scr1_cables;
    public Obj3D.Obj3DPart scr2_transporter;
    public Obj3D.Obj3DPart scr3_userin;
    public Obj3D.Obj3DPart scr5_dooropen;
    public Obj3D.Obj3DPart src4_doorclosed;
    public Obj3D.Obj3DPart gyro_alpha;
    public Obj3D.Obj3DPart gyro;
    public Obj3D.Obj3DPart whiteblur;
    public GhostGroup ghostDoorOpen;
    public GhostGroup ghostDoorClose;
    int areaH;
    public Coordonate areaCoordonate;
    public Coordonate lightCoordonate;
    public ElectricalCableDescriptor cable;
    Coordonate[] powerCoordonate;
    String chargeSound = null;
    float chargeVolume = 0.0f;

    public TeleporterDescriptor(String name, Obj3D obj, ElectricalCableDescriptor cable, Coordonate areaCoordonate, Coordonate lightCoordonate, int areaH, Coordonate[] powerCoordonate, GhostGroup ghostDoorOpen, GhostGroup ghostDoorClose) {
        super(name, TeleporterElement.class, TeleporterRender.class);
        this.cable = cable;
        this.obj = obj;
        this.powerCoordonate = powerCoordonate;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.ext_control = obj.getPart("ext_control");
            this.ext_power = obj.getPart("ext_power");
            this.door_out = obj.getPart("door_out");
            this.door_in_charge = obj.getPart("door_in_charge");
            this.door_in = obj.getPart("door_in");
            this.indoor_closed = obj.getPart("indoor_closed");
            this.indoor_open = obj.getPart("indoor_open");
            this.outlampline0_alpha = obj.getPart("outlampline0_alpha");
            this.outlampline0 = obj.getPart("outlampline0");
            this.scr0_electrictity = obj.getPart("scr0_electrictity");
            this.scr1_cables = obj.getPart("scr1_cables");
            this.scr2_transporter = obj.getPart("scr2_transporter");
            this.scr3_userin = obj.getPart("scr3_userin");
            this.scr5_dooropen = obj.getPart("scr5_dooropen");
            this.src4_doorclosed = obj.getPart("src4_doorclosed");
            this.gyro_alpha = obj.getPart("gyro_alpha");
            this.gyro = obj.getPart("gyro");
            this.whiteblur = obj.getPart("whiteblur");
            for (int idx = 0; idx < 10; ++idx) {
                this.leds[idx] = obj.getPart("led" + idx);
            }
        }
        this.areaCoordonate = areaCoordonate;
        this.areaH = areaH;
        this.ghostDoorClose = ghostDoorClose;
        this.ghostDoorOpen = ghostDoorOpen;
        this.lightCoordonate = lightCoordonate;
        this.voltageLevelColor = VoltageLevelColor.HighVoltage;
    }

    public AxisAlignedBB getBB(Coordonate c, Direction front) {
        Coordonate temp = new Coordonate(this.areaCoordonate);
        temp.setDimention(c.dimention);
        temp.applyTransformation(front, c);
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)temp.x, (double)temp.y, (double)temp.z, (double)(temp.x + 1), (double)(temp.y + this.areaH), (double)(temp.z + 1));
        return bb;
    }

    public Coordonate getTeleportCoordonate(Direction front, Coordonate c) {
        Coordonate temp = new Coordonate(this.areaCoordonate);
        temp.setDimention(c.dimention);
        temp.applyTransformation(front, c);
        return temp;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addMachine(this.newItemStack());
    }

    public void draw() {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.ext_control != null) {
            this.ext_control.draw();
        }
        if (this.ext_power != null) {
            this.ext_power.draw();
        }
        if (this.door_out != null) {
            this.door_out.draw();
        }
    }

    public Coordonate[] getPowerCoordonate(World w) {
        Coordonate[] temp = new Coordonate[this.powerCoordonate.length];
        for (int idx = 0; idx < temp.length; ++idx) {
            temp[idx] = new Coordonate(this.powerCoordonate[idx]);
            temp[idx].setDimention(w.field_73011_w.field_76574_g);
        }
        return temp;
    }

    @Override
    public int getSpawnDeltaX() {
        return 4;
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    public TeleporterDescriptor setChargeSound(String sound, float volume) {
        this.chargeSound = sound;
        this.chargeVolume = volume;
        return this;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.objItemScale(this.obj);
            this.main.draw();
            this.ext_control.draw();
            this.ext_power.draw();
            UtilsClient.disableCulling();
            this.door_out.draw();
            UtilsClient.enableCulling();
            this.indoor_open.draw();
        }
    }
}

