/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatoractive;

import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveElement;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class ThermalDissipatorActiveDescriptor
extends TransparentNodeDescriptor {
    double nominalP;
    double nominalT;
    private Obj3D obj;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart rot;
    double warmLimit;
    double coolLimit;
    double nominalElectricalU;
    double nominalElectricalCoolingPower;
    public double thermalRs;
    public double thermalRp;
    public double thermalC;
    double electricalRp;
    double electricalToThermalRp;
    public double electricalNominalP;
    ElectricalCableDescriptor cableDescriptor;

    public ThermalDissipatorActiveDescriptor(String name, Obj3D obj, double nominalElectricalU, double electricalNominalP, double nominalElectricalCoolingPower, ElectricalCableDescriptor cableDescriptor, double warmLimit, double coolLimit, double nominalP, double nominalT, double nominalTao, double nominalConnectionDrop) {
        super(name, ThermalDissipatorActiveElement.class, ThermalDissipatorActiveRender.class);
        this.cableDescriptor = cableDescriptor;
        this.electricalNominalP = electricalNominalP;
        this.nominalElectricalU = nominalElectricalU;
        this.nominalElectricalCoolingPower = nominalElectricalCoolingPower;
        this.electricalRp = nominalElectricalU * nominalElectricalU / electricalNominalP;
        this.electricalToThermalRp = nominalT / nominalElectricalCoolingPower;
        this.thermalC = (nominalP + nominalElectricalCoolingPower) * nominalTao / nominalT;
        this.thermalRp = nominalT / nominalP;
        this.thermalRs = nominalConnectionDrop / (nominalP + nominalElectricalCoolingPower);
        Eln.simulator.checkThermalLoad(this.thermalRs, this.thermalRp, this.thermalC);
        this.coolLimit = coolLimit;
        this.warmLimit = warmLimit;
        this.nominalP = nominalP;
        this.nominalT = nominalT;
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.rot = obj.getPart("rot");
        }
    }

    public void applyTo(ThermalLoad load) {
        load.set(this.thermalRs, this.thermalRp, this.thermalC);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addThermal(this.newItemStack());
    }

    public void applyTo(ElectricalLoad load, Resistor r) {
        this.cableDescriptor.applyTo(load);
        r.setR(this.electricalRp);
    }

    void draw(float alpha) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.rot != null) {
            this.rot.draw(alpha, 0.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.draw(0.0f);
    }

    @Override
    public boolean use2DIcon() {
        return false;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Used to cool down turbines.", new Object[0]));
        list.add(I18N.tr("Max. temperature: %1$\u00b0C", Utils.plotValue(this.warmLimit)));
        list.add(I18N.tr("Nominal usage:", new Object[0]));
        list.add("  " + I18N.tr("Temperature: %1$\u00b0C", Utils.plotValue(this.nominalT)));
        list.add("  " + I18N.tr("Cooling power: %1$W", Utils.plotValue(this.nominalP)));
        list.add("  " + I18N.tr("Fan voltage: %1$V", Utils.plotValue(this.nominalElectricalU)));
        list.add("  " + I18N.tr("Fan power consumption: %1$W", Utils.plotValue(this.electricalNominalP)));
        list.add("  " + I18N.tr("Fan cooling power: %1$W", Utils.plotValue(this.nominalElectricalCoolingPower)));
    }
}

